/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionStop;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileDecorateWelding;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.WeldingPoint;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionList
extends WithNote
implements Instruction,
InstructionCollection {
    private final List<Instruction> all = new ArrayList<Instruction>();
    private final Swimlane defaultSwimlane;
    private LinkRendering outlinkRendering;

    public InstructionList() {
        this(null);
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public boolean isOnlySingleStop() {
        return this.all.size() == 1 && this.getLast() instanceof InstructionStop && !((InstructionStop)this.getLast()).hasNotes();
    }

    public InstructionList(Swimlane swimlane) {
        this.defaultSwimlane = swimlane;
    }

    @Override
    public void add(Instruction instruction) {
        this.all.add(instruction);
    }

    @Override
    public Ftile createFtile(FtileFactory ftileFactory) {
        if (this.all.size() == 0) {
            return new FtileEmpty(ftileFactory.skinParam(), this.defaultSwimlane);
        }
        ArrayList<WeldingPoint> arrayList = new ArrayList<WeldingPoint>();
        Ftile ftile = this.eventuallyAddNote(ftileFactory, null, this.getSwimlaneIn());
        for (Instruction instruction : this.all) {
            Ftile ftile2 = instruction.createFtile(ftileFactory);
            arrayList.addAll(ftile2.getWeldingPoints());
            if (!instruction.getInLinkRendering().isNone()) {
                ftile2 = ftileFactory.decorateIn(ftile2, instruction.getInLinkRendering());
            }
            if (ftile == null) {
                ftile = ftile2;
                continue;
            }
            ftile = ftileFactory.assembly(ftile, ftile2);
        }
        if (this.outlinkRendering != null) {
            ftile = ftileFactory.decorateOut(ftile, this.outlinkRendering);
        }
        if (arrayList.size() > 0) {
            ftile = new FtileDecorateWelding(ftile, arrayList);
        }
        return ftile;
    }

    @Override
    public final boolean kill() {
        if (this.all.size() == 0) {
            return false;
        }
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.all.iterator().next().getInLinkRendering();
    }

    @Override
    public Instruction getLast() {
        if (this.all.size() == 0) {
            return null;
        }
        return this.all.get(this.all.size() - 1);
    }

    @Override
    public boolean addNote(Display display, NotePosition notePosition, NoteType noteType, Colors colors, Swimlane swimlane) {
        if (this.getLast() == null) {
            return super.addNote(display, notePosition, noteType, colors, swimlane);
        }
        return this.getLast().addNote(display, notePosition, noteType, colors, swimlane);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.all);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.defaultSwimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        Set<Swimlane> set = this.getSwimlanes();
        if (set.size() == 0) {
            return null;
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        return this.getLast().getSwimlaneOut();
    }

    public static Set<Swimlane> getSwimlanes2(List<? extends Instruction> list) {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        for (Instruction instruction : list) {
            hashSet.addAll(instruction.getSwimlanes());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public void setOutRendering(LinkRendering linkRendering) {
        this.outlinkRendering = linkRendering;
    }
}

