/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.SnakeDirection;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Worm
implements Iterable<Point2D.Double> {
    private final List<Point2D.Double> points = new ArrayList<Point2D.Double>();

    public boolean isPureHorizontal() {
        return this.points.size() == 2 && this.points.get(0).getY() == this.points.get(1).getY();
    }

    public void drawInternalOneColor(UGraphic uGraphic, HtmlColorAndStyle htmlColorAndStyle, double d, Direction direction, UPolygon uPolygon) {
        HtmlColor htmlColor = htmlColorAndStyle.getColor();
        if (htmlColor == null) {
            throw new IllegalArgumentException();
        }
        LinkStyle linkStyle = htmlColorAndStyle.getStyle();
        if (linkStyle == LinkStyle.INVISIBLE) {
            return;
        }
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor));
        uGraphic = linkStyle == LinkStyle.NORMAL ? uGraphic.apply(new UStroke(d)) : uGraphic.apply(LinkStyle.getStroke(linkStyle, d));
        boolean bl = false;
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D.Double double_ = this.points.get(i);
            Point2D.Double double_2 = this.points.get(i + 1);
            Line2D.Double double_3 = new Line2D.Double(double_, double_2);
            if (!bl && direction != null && Direction.fromVector(double_, double_2) == direction) {
                this.drawLine(uGraphic, double_3, direction);
                bl = true;
                continue;
            }
            this.drawLine(uGraphic, double_3, null);
        }
        if (uPolygon != null) {
            uGraphic = uGraphic.apply(new UStroke(1.5));
            Point2D point2D = this.points.get(this.points.size() - 1);
            uGraphic.apply(new UTranslate(point2D)).apply(new UStroke()).draw(uPolygon);
        }
    }

    private void drawLine(UGraphic uGraphic, Line2D line2D, Direction direction) {
        this.drawLine(uGraphic, line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2(), direction);
    }

    private void drawLine(UGraphic uGraphic, double d, double d2, double d3, double d4, Direction direction) {
        uGraphic = uGraphic.apply(new UTranslate(d, d2));
        if (direction != null) {
            uGraphic.apply(new UTranslate((d3 - d) / 2.0, (d4 - d2) / 2.0)).draw(Arrows.asTo(direction));
        }
        uGraphic.draw(new ULine(d3 - d, d4 - d2));
    }

    public Worm move(double d, double d2) {
        Worm worm = new Worm();
        for (Point2D point2D : this.points) {
            worm.addPoint(point2D.getX() + d, point2D.getY() + d2);
        }
        return worm;
    }

    public Worm moveFirstPoint(UTranslate uTranslate) {
        double d = uTranslate.getDx();
        double d2 = uTranslate.getDy();
        if (d != 0.0 && d2 != 0.0) {
            throw new IllegalArgumentException("move=" + uTranslate);
        }
        Worm worm = new Worm();
        double d3 = this.points.get(0).getX();
        double d4 = this.points.get(0).getY();
        double d5 = this.points.get(1).getX();
        double d6 = this.points.get(1).getY();
        if (d != 0.0 && d3 == d5) {
            d5 += d;
        }
        if (d2 != 0.0 && d4 == d6) {
            d6 += d2;
        }
        worm.addPoint(d3 += d, d4 += d2);
        worm.addPoint(d5, d6);
        for (int i = 2; i < this.points.size(); ++i) {
            worm.addPoint(this.points.get(i));
        }
        return worm;
    }

    public Worm moveLastPoint(UTranslate uTranslate) {
        double d = uTranslate.getDx();
        double d2 = uTranslate.getDy();
        if (d != 0.0 && d2 != 0.0) {
            throw new IllegalArgumentException("move=" + uTranslate);
        }
        Worm worm = new Worm();
        double d3 = this.points.get(this.points.size() - 2).getX();
        double d4 = this.points.get(this.points.size() - 2).getY();
        double d5 = this.points.get(this.points.size() - 1).getX();
        double d6 = this.points.get(this.points.size() - 1).getY();
        if (d != 0.0 && d3 == d5) {
            d3 += d;
        }
        if (d2 != 0.0 && d4 == d6) {
            d4 += d2;
        }
        d5 += d;
        d6 += d2;
        for (int i = 0; i < this.points.size() - 2; ++i) {
            worm.addPoint(this.points.get(i));
        }
        worm.addPoint(d3, d4);
        worm.addPoint(d5, d6);
        return worm;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            stringBuilder.append((Object)((Object)this.getDirectionAtPoint(i)) + " ");
        }
        return stringBuilder + this.points.toString();
    }

    public void addPoint(double d, double d2) {
        this.points.add(new Point2D.Double(d, d2));
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public Worm translate(UTranslate uTranslate) {
        return this.move(uTranslate.getDx(), uTranslate.getDy());
    }

    SnakeDirection getDirection() {
        if (this.points.size() < 2) {
            throw new IllegalStateException();
        }
        return SnakeDirection.getDirection(this.points.get(0), this.points.get(1));
    }

    String getDirectionsCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction direction = Direction.fromVector(this.points.get(i), this.points.get(i + 1));
            stringBuilder.append(direction.getShortCode());
        }
        return stringBuilder.toString();
    }

    private List<Direction> getPatternAt(int n) {
        return Arrays.asList(this.getDirectionAtPoint(n), this.getDirectionAtPoint(n + 1), this.getDirectionAtPoint(n + 2), this.getDirectionAtPoint(n + 3));
    }

    private boolean isForwardAndBackwardAt(int n) {
        return this.getDirectionAtPoint(n) == this.getDirectionAtPoint(n + 1).getInv();
    }

    private Direction getDirectionAtPoint(int n) {
        return Direction.fromVector(this.points.get(n), this.points.get(n + 1));
    }

    @Override
    public Iterator<Point2D.Double> iterator() {
        return Collections.unmodifiableCollection(this.points).iterator();
    }

    public int size() {
        return this.points.size();
    }

    public Point2D.Double get(int n) {
        return this.points.get(n);
    }

    public void addAll(Worm worm) {
        this.points.addAll(worm.points);
    }

    public void remove(int n) {
        this.points.remove(n);
    }

    public void add(int n, Point2D.Double double_) {
        this.points.add(n, double_);
    }

    private Point2D getFirst() {
        return this.points.get(0);
    }

    public Point2D getLast() {
        return this.points.get(this.points.size() - 1);
    }

    public Worm merge(Worm worm, MergeStrategy mergeStrategy) {
        if (!Snake.same(this.getLast(), worm.getFirst())) {
            throw new IllegalArgumentException();
        }
        Worm worm2 = new Worm();
        worm2.points.addAll(this.points);
        worm2.points.addAll(worm.points);
        worm2.mergeMe(mergeStrategy);
        return worm2;
    }

    private void mergeMe(MergeStrategy mergeStrategy) {
        boolean bl = false;
        do {
            bl = (bl = false) || this.removeNullVector();
            bl = bl || this.removeRedondantDirection();
            bl = bl || this.removePattern1();
            bl = bl || this.removePattern2();
            bl = bl || this.removePattern3();
            bl = bl || this.removePattern4();
            bl = bl || this.removePattern5();
            bl = bl || this.removePattern6();
            boolean bl2 = bl = bl || this.removePattern7();
            if (mergeStrategy != MergeStrategy.FULL) continue;
            boolean bl3 = bl = bl || this.removePattern8();
        } while (bl);
    }

    private boolean removeNullVector() {
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Direction direction = this.getDirectionAtPoint(i);
            if (direction != null) continue;
            this.points.remove(i);
            return true;
        }
        return false;
    }

    private boolean removeRedondantDirection() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            Direction direction;
            Direction direction2 = this.getDirectionAtPoint(i);
            if (direction2 != (direction = this.getDirectionAtPoint(i + 1))) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern1() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> list = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(list) && !Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(list)) continue;
            Point2D.Double double_ = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, double_);
            return true;
        }
        return false;
    }

    private boolean removePattern7() {
        if (this.points.size() > 4) {
            List<Direction> list = this.getPatternAt(0);
            if (Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(list) && this.points.get((int)3).x > this.points.get((int)0).x) {
                Point2D.Double double_ = new Point2D.Double(this.points.get((int)3).x, this.points.get((int)0).y);
                this.points.remove(2);
                this.points.remove(1);
                this.points.add(1, double_);
                return true;
            }
        }
        return false;
    }

    private boolean removePattern2() {
        for (int i = 0; i < this.points.size() - 5; ++i) {
            List<Direction> list = this.getPatternAt(i);
            if (!Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.UP).equals(list) && !Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.UP).equals(list)) continue;
            Point2D.Double double_ = new Point2D.Double(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, double_);
            return true;
        }
        return false;
    }

    private boolean removePattern3() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> list = this.getPatternAt(i);
            if (!Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.RIGHT).equals(list) && !Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.LEFT).equals(list)) continue;
            Point2D.Double double_ = new Point2D.Double(this.points.get((int)(i + 1)).x, this.points.get((int)(i + 3)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, double_);
            return true;
        }
        return false;
    }

    private boolean removePattern4() {
        int n = this.points.size() - 5;
        if (n >= 0) {
            List<Direction> list = this.getPatternAt(n);
            if (Arrays.asList(Direction.DOWN, Direction.LEFT, Direction.DOWN, Direction.RIGHT).equals(list)) {
                Point2D.Double double_ = this.points.get(n + 1);
                Point2D.Double double_2 = this.points.get(n + 4);
                if (double_2.x > double_.x) {
                    Point2D.Double double_3 = new Point2D.Double(this.points.get((int)(n + 1)).x, this.points.get((int)(n + 3)).y);
                    this.points.remove(n + 3);
                    this.points.remove(n + 2);
                    this.points.remove(n + 1);
                    this.points.add(n + 1, double_3);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern5() {
        int n = this.points.size() - 5;
        if (n >= 0) {
            List<Direction> list = this.getPatternAt(n);
            if (Arrays.asList(Direction.DOWN, Direction.RIGHT, Direction.DOWN, Direction.LEFT).equals(list)) {
                Point2D.Double double_ = this.points.get(n + 1);
                Point2D.Double double_2 = this.points.get(n + 4);
                if (double_2.x + 4.0 < double_.x) {
                    Point2D.Double double_3 = new Point2D.Double(this.points.get((int)(n + 1)).x, this.points.get((int)(n + 3)).y);
                    this.points.remove(n + 3);
                    this.points.remove(n + 2);
                    this.points.remove(n + 1);
                    this.points.add(n + 1, double_3);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean removePattern6() {
        for (int i = 0; i < this.points.size() - 2; ++i) {
            if (!this.isForwardAndBackwardAt(i)) continue;
            this.points.remove(i + 1);
            return true;
        }
        return false;
    }

    private boolean removePattern8() {
        for (int i = 0; i < this.points.size() - 4; ++i) {
            List<Direction> list = this.getPatternAt(i);
            if (!Arrays.asList(Direction.LEFT, Direction.DOWN, Direction.LEFT, Direction.DOWN).equals(list) && !Arrays.asList(Direction.RIGHT, Direction.DOWN, Direction.RIGHT, Direction.DOWN).equals(list)) continue;
            Point2D.Double double_ = new Point2D.Double(this.points.get((int)(i + 3)).x, this.points.get((int)(i + 1)).y);
            this.points.remove(i + 3);
            this.points.remove(i + 2);
            this.points.remove(i + 1);
            this.points.add(i + 1, double_);
            return true;
        }
        return false;
    }
}

