/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileIfAndStop
extends AbstractFtile {
    private final Ftile tile1;
    private final Ftile diamond1;
    private final Ftile stop2;
    private final Rainbow arrowColor;

    private FtileIfAndStop(Ftile ftile, Ftile ftile2, Rainbow rainbow, Ftile ftile3) {
        super(ftile2.skinParam());
        this.diamond1 = ftile;
        this.tile1 = ftile2;
        this.stop2 = ftile3;
        this.arrowColor = rainbow;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            hashSet.add(this.getSwimlaneIn());
        }
        hashSet.addAll(this.tile1.getSwimlanes());
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, Rainbow rainbow, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch, ISkinParam iSkinParam, StringBounder stringBounder, Display display) {
        AbstractFtile abstractFtile;
        Ftile ftile = branch.getFtile();
        FontConfiguration fontConfiguration = new FontConfiguration(iSkinParam, FontParam.ACTIVITY_DIAMOND, null);
        Ftile ftile2 = ftileFactory.stop(swimlane);
        Sheet sheet = new CreoleParser(fontConfiguration, iSkinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), iSkinParam, CreoleMode.FULL).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, iSkinParam.getPadding());
        SheetBlock2 sheetBlock2 = new SheetBlock2(sheetBlock1, Diamond.asStencil(sheetBlock1), ftile.getThickness());
        if (conditionStyle == ConditionStyle.INSIDE) {
            abstractFtile = new FtileDiamondInside(ftile.skinParam(), htmlColor2, htmlColor, swimlane, sheetBlock2);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            abstractFtile = new FtileDiamond(ftile.skinParam(), htmlColor2, htmlColor, swimlane).withNorth(sheetBlock2);
        } else {
            throw new IllegalStateException();
        }
        FtileIfAndStop ftileIfAndStop = new FtileIfAndStop(abstractFtile, ftile, rainbow, ftile2);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        FtileIfAndStop ftileIfAndStop2 = ftileIfAndStop;
        ftileIfAndStop2.getClass();
        arrayList.add(ftileIfAndStop2.new ConnectionHorizontal(rainbow));
        return FtileUtils.addConnection((Ftile)ftileIfAndStop, arrayList);
    }

    private UTranslate getTranslate1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.tile1.calculateDimension(stringBounder);
        double d = this.calculateDimension(stringBounder).getLeft() - ftileGeometry3.getLeft();
        double d2 = ftileGeometry2.getHeight() + (double)this.getSuppHeight();
        return new UTranslate(d, d2);
    }

    private int getSuppHeight() {
        return 30;
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        double d = this.calculateDimension(stringBounder).getLeft() - ((Dimension2D)ftileGeometry).getWidth() / 2.0;
        return new UTranslate(d, 0.0);
    }

    private UTranslate getTranslateStop(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.stop2.calculateDimension(stringBounder);
        double d = (((Dimension2D)ftileGeometry).getHeight() - ((Dimension2D)ftileGeometry2).getHeight()) / 2.0;
        double d2 = this.calculateDimension(stringBounder).getLeft() + ((Dimension2D)ftileGeometry).getWidth() / 2.0 + this.getDiamondStopDistance();
        return new UTranslate(d2, d);
    }

    private double getDiamondStopDistance() {
        return 40.0;
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        if (ftile == this.tile1) {
            return this.getTranslate1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        uGraphic.apply(this.getTranslate1(stringBounder)).draw(this.tile1);
        uGraphic.apply(this.getTranslateStop(stringBounder)).draw(this.stop2);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.stop2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.tile1.calculateDimension(stringBounder).addDim(0.0, this.getDiamondStopDistance() + ((Dimension2D)ftileGeometry).getWidth());
        FtileGeometry ftileGeometry3 = this.diamond1.calculateDimension(stringBounder);
        return ftileGeometry3.appendBottom(ftileGeometry2).addDim(0.0, this.getSuppHeight());
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionHorizontal(Rainbow rainbow) {
            super(FtileIfAndStop.this.diamond1, FtileIfAndStop.this.stop2);
            this.color = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToRight());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(((Dimension2D)ftileGeometry).getWidth(), ((Dimension2D)ftileGeometry).getHeight() / 2.0);
            return FtileIfAndStop.this.getTranslateDiamond1(stringBounder).getTranslated(double_);
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(0.0, ((Dimension2D)ftileGeometry).getHeight() / 2.0);
            return FtileIfAndStop.this.getTranslateStop(stringBounder).getTranslated(double_);
        }
    }
}

