/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileIfDown
extends AbstractFtile {
    private final Ftile thenBlock;
    private final Ftile diamond1;
    private final Ftile diamond2;
    private final Ftile optionalStop;

    @Override
    public Collection<Ftile> getMyChildren() {
        if (this.optionalStop == null) {
            return Arrays.asList(this.thenBlock, this.diamond1, this.diamond2);
        }
        return Arrays.asList(this.thenBlock, this.diamond1, this.diamond2, this.optionalStop);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>(this.thenBlock.getSwimlanes());
        hashSet.add(this.getSwimlaneIn());
        return hashSet;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        if (this.optionalStop == null) {
            return this.getSwimlaneIn();
        }
        return this.thenBlock.getSwimlaneOut();
    }

    private FtileIfDown(Ftile ftile, Ftile ftile2, Ftile ftile3, Ftile ftile4) {
        super(ftile.skinParam());
        this.thenBlock = ftile;
        this.diamond1 = ftile2;
        this.diamond2 = ftile3;
        this.optionalStop = ftile4;
    }

    public static Ftile create(Ftile ftile, Ftile ftile2, Swimlane swimlane, Ftile ftile3, Rainbow rainbow, FtileFactory ftileFactory, Ftile ftile4, Rainbow rainbow2) {
        rainbow2 = rainbow2.withDefault(rainbow);
        FtileIfDown ftileIfDown = new FtileIfDown(ftile3, ftile, ftile4 == null ? ftile2 : new FtileEmpty(ftileFactory.skinParam()), ftile4);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        FtileIfDown ftileIfDown2 = ftileIfDown;
        ftileIfDown2.getClass();
        arrayList.add(ftileIfDown2.new ConnectionIn(ftile3.getInLinkRendering().getRainbow(rainbow)));
        boolean bl = ftile3.calculateDimension(ftileFactory.getStringBounder()).hasPointOut();
        if (ftile4 == null) {
            if (bl) {
                FtileIfDown ftileIfDown3 = ftileIfDown;
                ftileIfDown3.getClass();
                arrayList.add(ftileIfDown3.new ConnectionElse(rainbow2));
            } else {
                FtileIfDown ftileIfDown4 = ftileIfDown;
                ftileIfDown4.getClass();
                arrayList.add(ftileIfDown4.new ConnectionElseNoDiamond(rainbow2));
            }
        } else {
            FtileIfDown ftileIfDown5 = ftileIfDown;
            ftileIfDown5.getClass();
            arrayList.add(ftileIfDown5.new ConnectionHorizontal(rainbow2));
        }
        FtileIfDown ftileIfDown6 = ftileIfDown;
        ftileIfDown6.getClass();
        arrayList.add(ftileIfDown6.new ConnectionOut(ftile3.getOutLinkRendering().getRainbow(rainbow)));
        return FtileUtils.addConnection((Ftile)ftileIfDown, arrayList);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateForThen(stringBounder)).draw(this.thenBlock);
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        if (this.optionalStop == null) {
            uGraphic.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
        } else {
            uGraphic.apply(this.getTranslateOptionalStop(stringBounder)).draw(this.optionalStop);
        }
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.thenBlock.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry4 = ftileGeometry.appendBottom(ftileGeometry2).appendBottom(ftileGeometry3);
        double d = ftileGeometry4.getHeight() + 36.0 + Math.max(12.0, this.getSouthLabelHeight(stringBounder));
        double d2 = ftileGeometry4.getWidth() + 12.0;
        if (this.optionalStop != null) {
            d2 += this.optionalStop.calculateDimension(stringBounder).getWidth() + this.getAdditionalWidth(stringBounder);
        }
        return new FtileGeometry(d2, d, ftileGeometry4.getLeft(), ftileGeometry.getInY(), d);
    }

    private double getAdditionalWidth(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.optionalStop.calculateDimension(stringBounder);
        double d = this.getEastLabelWidth(stringBounder);
        double d2 = ftileGeometry.getWidth();
        return Math.max(d2, d + d2 / 2.0);
    }

    private double getSouthLabelHeight(StringBounder stringBounder) {
        if (this.diamond1 instanceof FtileDiamondInside) {
            return ((FtileDiamondInside)this.diamond1).getSouthLabelHeight(stringBounder);
        }
        if (this.diamond1 instanceof FtileDiamond) {
            return ((FtileDiamond)this.diamond1).getSouthLabelHeight(stringBounder);
        }
        return 0.0;
    }

    private double getEastLabelWidth(StringBounder stringBounder) {
        if (this.diamond1 instanceof FtileDiamondInside) {
            return ((FtileDiamondInside)this.diamond1).getEastLabelWidth(stringBounder);
        }
        if (this.diamond1 instanceof FtileDiamond) {
            return ((FtileDiamond)this.diamond1).getEastLabelWidth(stringBounder);
        }
        return 0.0;
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.thenBlock) {
            return this.getTranslateForThen(stringBounder);
        }
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        if (ftile == this.optionalStop) {
            return this.getTranslateOptionalStop(stringBounder);
        }
        if (ftile == this.diamond2) {
            return this.getTranslateDiamond2(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForThen(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry4 = this.thenBlock.calculateDimension(stringBounder);
        double d = ftileGeometry.getHeight() + (ftileGeometry3.getHeight() - ftileGeometry.getHeight() - ftileGeometry2.getHeight() - ftileGeometry4.getHeight()) / 2.0;
        double d2 = ftileGeometry3.getLeft() - ftileGeometry4.getLeft();
        return new UTranslate(d2, d);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond1.calculateDimension(stringBounder);
        double d = ftileGeometry.getLeft() - ftileGeometry2.getLeft();
        return new UTranslate(d, 0.0);
    }

    private UTranslate getTranslateOptionalStop(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.optionalStop.calculateDimension(stringBounder);
        double d = ftileGeometry2.getInY();
        double d2 = d + (ftileGeometry2.getHeight() - d - ftileGeometry3.getHeight()) / 2.0;
        double d3 = ftileGeometry.getLeft() - ftileGeometry2.getLeft() + ftileGeometry2.getWidth() + this.getAdditionalWidth(stringBounder);
        return new UTranslate(d3, d2);
    }

    private UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        double d = ftileGeometry.getHeight() - ftileGeometry2.getHeight();
        double d2 = ftileGeometry.getLeft() - ftileGeometry2.getLeft();
        return new UTranslate(d2, d);
    }

    class ConnectionElseNoDiamond
    extends ConnectionElse {
        public ConnectionElseNoDiamond(Rainbow rainbow) {
            super(rainbow);
        }

        protected Point2D getP2(StringBounder stringBounder) {
            return FtileIfDown.this.calculateDimension(stringBounder).getPointOut();
        }
    }

    class ConnectionElse
    extends AbstractConnection {
        private final Rainbow endInlinkColor;

        public ConnectionElse(Rainbow rainbow) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.diamond2);
            this.endInlinkColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileIfDown.this.diamond1.calculateDimension(stringBounder);
            double d = ftileGeometry.getWidth();
            double d2 = (ftileGeometry.getOutY() - ftileGeometry.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(d, ftileGeometry.getInY() + d2));
        }

        protected Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileIfDown.this.diamond2.calculateDimension(stringBounder);
            double d = ftileGeometry.getWidth();
            double d2 = (ftileGeometry.getOutY() - ftileGeometry.getInY()) / 2.0;
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(d, ftileGeometry.getInY() + d2));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.endInlinkColor, Arrows.asToLeft());
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            snake.addPoint(d, d2);
            FtileGeometry ftileGeometry = FtileIfDown.this.thenBlock.calculateDimension(stringBounder);
            double d5 = Math.max(d + 12.0, FtileIfDown.this.getTranslateForThen(stringBounder).getDx() + ftileGeometry.getWidth());
            snake.addPoint(d5, d2);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            snake.emphasizeDirection(Direction.DOWN);
            uGraphic.apply(new UTranslate(d3, d4 - 12.0)).draw(new UEmpty(5.0, 12.0));
            uGraphic.draw(snake);
        }
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionOut(Rainbow rainbow) {
            super(FtileIfDown.this.thenBlock, FtileIfDown.this.diamond2);
            this.arrowColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateForThen(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateDiamond2(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            if (!this.getFtile1().calculateDimension(uGraphic.getStringBounder()).hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            if (!this.getFtile1().calculateDimension(uGraphic.getStringBounder()).hasPointOut()) {
                return;
            }
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            double d = (point2D3.getY() + point2D4.getY()) / 2.0;
            snake.addPoint(point2D3);
            snake.addPoint(point2D3.getX(), d);
            snake.addPoint(point2D4.getX(), d);
            snake.addPoint(point2D4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionIn(Rainbow rainbow) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.thenBlock);
            this.arrowColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileIfDown.this.getTranslateForThen(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            double d = (point2D3.getY() + point2D4.getY()) / 2.0;
            snake.addPoint(point2D3);
            snake.addPoint(point2D3.getX(), d);
            snake.addPoint(point2D4.getX(), d);
            snake.addPoint(point2D4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionHorizontal
    extends AbstractConnection {
        private final Rainbow color;

        public ConnectionHorizontal(Rainbow rainbow) {
            super(FtileIfDown.this.diamond1, FtileIfDown.this.optionalStop);
            this.color = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.color, Arrows.asToRight());
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getWidth(), (ftileGeometry.getInY() + ftileGeometry.getOutY()) / 2.0);
            return FtileIfDown.this.getTranslateDiamond1(stringBounder).getTranslated(double_);
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(stringBounder);
            Point2D.Double double_ = new Point2D.Double(0.0, ((Dimension2D)ftileGeometry).getHeight() / 2.0);
            return FtileIfDown.this.getTranslateOptionalStop(stringBounder).getTranslated(double_);
        }
    }
}

