/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondFoo1;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileRepeat
extends AbstractFtile {
    private final Ftile repeat;
    private final Ftile diamond1;
    private final Ftile diamond2;
    private final Ftile backward;
    private final TextBlock tbTest;

    @Override
    public Collection<Ftile> getMyChildren() {
        return Arrays.asList(this.repeat, this.diamond1, this.diamond2);
    }

    private FtileRepeat(Ftile ftile, Ftile ftile2, Ftile ftile3, TextBlock textBlock, Ftile ftile4) {
        super(ftile.skinParam());
        this.repeat = ftile;
        this.diamond1 = ftile2;
        this.diamond2 = ftile3;
        this.tbTest = textBlock;
        this.backward = ftile4;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.repeat.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.diamond2.getSwimlaneOut();
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeat.getSwimlanes();
    }

    public static Ftile create(LinkRendering linkRendering, Swimlane swimlane, Swimlane swimlane2, Ftile ftile, Ftile ftile2, Display display, Display display2, Display display3, HtmlColor htmlColor, HtmlColor htmlColor2, Rainbow rainbow, Rainbow rainbow2, ConditionStyle conditionStyle, ISkinSimple iSkinSimple, FontConfiguration fontConfiguration, FontConfiguration fontConfiguration2, Ftile ftile3) {
        TextBlock textBlock;
        FtileRepeat ftileRepeat;
        Object object;
        FontConfiguration fontConfiguration3 = conditionStyle == ConditionStyle.INSIDE ? fontConfiguration : fontConfiguration2;
        TextBlock textBlock2 = Display.isNull(display) || display.isWhite() ? TextBlockUtils.empty(0.0, 0.0) : display.create(fontConfiguration3, ftile2.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), iSkinSimple);
        TextBlock textBlock3 = display2.create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple);
        TextBlock textBlock4 = display3.create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple);
        Ftile ftile4 = ftile == null ? new FtileDiamond(ftile2.skinParam(), htmlColor2, htmlColor, swimlane) : ftile;
        if (conditionStyle == ConditionStyle.INSIDE) {
            object = new FtileDiamondInside(ftile2.skinParam(), htmlColor2, htmlColor, swimlane2, textBlock2).withEast(textBlock3).withSouth(textBlock4);
            ftileRepeat = new FtileRepeat(ftile2, ftile4, (Ftile)object, TextBlockUtils.empty(0.0, 0.0), ftile3);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            object = new FtileDiamond(ftile2.skinParam(), htmlColor2, htmlColor, swimlane).withEast(textBlock2);
            ftileRepeat = new FtileRepeat(ftile2, ftile4, (Ftile)object, textBlock2, ftile3);
        } else if (conditionStyle == ConditionStyle.FOO1) {
            object = new FtileDiamondFoo1(ftile2.skinParam(), htmlColor2, htmlColor, swimlane, textBlock2);
            ftileRepeat = new FtileRepeat(ftile2, ftile4, (Ftile)object, TextBlockUtils.empty(0.0, 0.0), ftile3);
        } else {
            throw new IllegalStateException();
        }
        object = new ArrayList();
        Display display4 = ftile2.getInLinkRendering().getDisplay();
        TextBlock textBlock5 = display4 == null ? null : display4.create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple, CreoleMode.SIMPLE_LINE);
        FtileRepeat ftileRepeat2 = ftileRepeat;
        ftileRepeat2.getClass();
        object.add(ftileRepeat2.new ConnectionIn(ftile2.getInLinkRendering().getRainbow(rainbow), textBlock5));
        Display display5 = linkRendering.getDisplay();
        TextBlock textBlock6 = textBlock = display5 == null ? null : display5.create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple, CreoleMode.SIMPLE_LINE);
        if (ftile2.getSwimlaneIn() == ftile2.getSwimlaneOut()) {
            if (ftile3 == null) {
                FtileRepeat ftileRepeat3 = ftileRepeat;
                ftileRepeat3.getClass();
                object.add(ftileRepeat3.new ConnectionBackSimple(linkRendering.getRainbow(rainbow), textBlock));
            } else {
                FtileRepeat ftileRepeat4 = ftileRepeat;
                ftileRepeat4.getClass();
                object.add(ftileRepeat4.new ConnectionBackBackward1(linkRendering.getRainbow(rainbow), textBlock));
                FtileRepeat ftileRepeat5 = ftileRepeat;
                ftileRepeat5.getClass();
                object.add(ftileRepeat5.new ConnectionBackBackward2(linkRendering.getRainbow(rainbow)));
            }
        } else {
            FtileRepeat ftileRepeat6 = ftileRepeat;
            ftileRepeat6.getClass();
            object.add(ftileRepeat6.new ConnectionBackComplex1(linkRendering.getRainbow(rainbow)));
            FtileRepeat ftileRepeat7 = ftileRepeat;
            ftileRepeat7.getClass();
            object.add(ftileRepeat7.new ConnectionBackComplexHorizontalOnly(linkRendering.getRainbow(rainbow), textBlock));
        }
        Display display6 = ftile2.getOutLinkRendering().getDisplay();
        TextBlock textBlock7 = display6 == null ? null : display6.create(fontConfiguration2, HorizontalAlignment.LEFT, iSkinSimple, CreoleMode.SIMPLE_LINE);
        Rainbow rainbow3 = rainbow2.withDefault(rainbow);
        FtileRepeat ftileRepeat8 = ftileRepeat;
        ftileRepeat8.getClass();
        object.add(ftileRepeat8.new ConnectionOut(rainbow3, textBlock7));
        return FtileUtils.addConnection((Ftile)ftileRepeat, (Collection<Connection>)object);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateForRepeat(stringBounder)).draw(this.repeat);
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        uGraphic.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
        if (this.backward != null) {
            uGraphic.apply(this.getTranslateBackward(stringBounder)).draw(this.backward);
        }
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new FtileGeometry(dimension2D, this.getLeft(stringBounder), 0.0, dimension2D.getHeight());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.repeat.calculateDimension(stringBounder);
        double d = this.tbTest.calculateDimension(stringBounder).getWidth();
        double d2 = this.getLeft(stringBounder) + this.getRight(stringBounder);
        d2 = Math.max(d2, d + 24.0);
        if (this.backward != null) {
            d2 += this.backward.calculateDimension(stringBounder).getWidth();
        }
        double d3 = ((Dimension2D)ftileGeometry).getHeight() + ((Dimension2D)ftileGeometry3).getHeight() + ((Dimension2D)ftileGeometry2).getHeight() + 96.0;
        return new Dimension2DDouble(d2 + 24.0, d3);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.repeat) {
            return this.getTranslateForRepeat(stringBounder);
        }
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForRepeat(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry3 = this.repeat.calculateDimension(stringBounder);
        double d = dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight() - ((Dimension2D)ftileGeometry2).getHeight() - ((Dimension2D)ftileGeometry3).getHeight();
        double d2 = ((Dimension2D)ftileGeometry).getHeight() + d / 2.0;
        double d3 = this.getLeft(stringBounder);
        return new UTranslate(d3 - this.repeat.calculateDimension(stringBounder).getLeft(), d2);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        double d = this.getLeft(stringBounder);
        return new UTranslate(d - ((Dimension2D)ftileGeometry).getWidth() / 2.0, 0.0);
    }

    private UTranslate getTranslateBackward(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.backward.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - ((Dimension2D)ftileGeometry).getWidth();
        double d2 = (dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight()) / 2.0;
        return new UTranslate(d, d2);
    }

    private UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.diamond2.calculateDimension(stringBounder);
        double d = dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight();
        double d2 = this.getLeft(stringBounder);
        return new UTranslate(d2 - ((Dimension2D)ftileGeometry).getWidth() / 2.0, d);
    }

    private double getLeft(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        double d = this.repeat.calculateDimension(stringBounder).getLeft();
        d = Math.max(d, ((Dimension2D)ftileGeometry).getWidth() / 2.0);
        double d2 = this.repeat.calculateDimension(stringBounder).getLeft();
        d2 = Math.max(d2, ((Dimension2D)ftileGeometry2).getWidth() / 2.0);
        return Math.max(d, d2);
    }

    private double getRight(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.repeat.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry3).getWidth() - this.repeat.calculateDimension(stringBounder).getLeft();
        d = Math.max(d, ((Dimension2D)ftileGeometry).getWidth() / 2.0);
        double d2 = ((Dimension2D)ftileGeometry3).getWidth() - this.repeat.calculateDimension(stringBounder).getLeft();
        d2 = Math.max(d2, ((Dimension2D)ftileGeometry2).getWidth() / 2.0);
        return Math.max(d, d2);
    }

    class ConnectionBackSimple
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final TextBlock tbback;

        public ConnectionBackSimple(Rainbow rainbow, TextBlock textBlock) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.repeat);
            this.arrowColor = rainbow;
            this.tbback = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToLeft());
            snake.setLabel(this.tbback);
            snake.emphasizeDirection(Direction.UP);
            Dimension2D dimension2D = FtileRepeat.this.calculateDimensionInternal(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            FtileGeometry ftileGeometry2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double d = point2D.getX() + ((Dimension2D)ftileGeometry2).getWidth();
            double d2 = point2D.getY() + ((Dimension2D)ftileGeometry2).getHeight() / 2.0;
            double d3 = point2D2.getX() + ((Dimension2D)ftileGeometry).getWidth();
            double d4 = point2D2.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            snake.addPoint(d, d2);
            double d5 = dimension2D.getWidth() - 12.0;
            snake.addPoint(d5, d2);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionBackBackward2
    extends AbstractConnection {
        private final Rainbow arrowColor;

        public ConnectionBackBackward2(Rainbow rainbow) {
            super(FtileRepeat.this.backward, FtileRepeat.this.diamond1);
            this.arrowColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileRepeat.this.backward.calculateDimension(stringBounder);
            return FtileRepeat.this.getTranslateBackward(stringBounder).getTranslated(new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getInY()));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToLeft());
            snake.emphasizeDirection(Direction.UP);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX() + ((Dimension2D)ftileGeometry).getWidth();
            double d4 = point2D2.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            snake.addPoint(d, d2);
            snake.addPoint(d, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionBackBackward1
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final TextBlock tbback;

        public ConnectionBackBackward1(Rainbow rainbow, TextBlock textBlock) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.backward);
            this.arrowColor = rainbow;
            this.tbback = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileRepeat.this.backward.calculateDimension(stringBounder);
            return FtileRepeat.this.getTranslateBackward(stringBounder).getTranslated(new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getOutY()));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToUp());
            snake.setLabel(this.tbback);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double d = point2D.getX() + ((Dimension2D)ftileGeometry).getWidth();
            double d2 = point2D.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            snake.addPoint(d, d2);
            snake.addPoint(d3, d2);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionBackComplexHorizontalOnly
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final TextBlock tbback;

        public ConnectionBackComplexHorizontalOnly(Rainbow rainbow, TextBlock textBlock) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.diamond2);
            this.arrowColor = rainbow;
            this.tbback = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, null);
            snake.setLabel(this.tbback);
            FtileGeometry ftileGeometry = FtileRepeat.this.repeat.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            FtileGeometry ftileGeometry2 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double d = point2D.getX() + ((Dimension2D)ftileGeometry2).getWidth();
            double d2 = point2D.getY() + ((Dimension2D)ftileGeometry2).getHeight() / 2.0;
            snake.addPoint(d, d2);
            double d3 = point2D.getX() + ((Dimension2D)ftileGeometry2).getWidth() / 2.0 + ((Dimension2D)ftileGeometry).getWidth() / 2.0 + 12.0;
            snake.addPoint(d3, d2);
            uGraphic.draw(snake);
        }
    }

    class ConnectionBackComplex1
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionBackComplex1(Rainbow rainbow) {
            super(FtileRepeat.this.diamond2, FtileRepeat.this.repeat);
            this.arrowColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToLeft());
            snake.emphasizeDirection(Direction.UP);
            FtileGeometry ftileGeometry = FtileRepeat.this.repeat.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            point2D = uTranslate.getTranslated(point2D);
            point2D2 = uTranslate2.getTranslated(point2D2);
            FtileGeometry ftileGeometry2 = FtileRepeat.this.diamond1.calculateDimension(stringBounder);
            FtileGeometry ftileGeometry3 = FtileRepeat.this.diamond2.calculateDimension(stringBounder);
            double d = point2D.getY() + ((Dimension2D)ftileGeometry3).getHeight() / 2.0;
            double d2 = point2D2.getX() + ((Dimension2D)ftileGeometry2).getWidth();
            double d3 = point2D2.getY() + ((Dimension2D)ftileGeometry2).getHeight() / 2.0;
            double d4 = point2D.getX() + ((Dimension2D)ftileGeometry3).getWidth() / 2.0 + ((Dimension2D)ftileGeometry).getWidth() / 2.0 + 12.0;
            snake.addPoint(d4, d);
            snake.addPoint(d4, d3);
            snake.addPoint(d2, d3);
            uGraphic.draw(snake);
        }
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;
        private final TextBlock tbout;

        public ConnectionOut(Rainbow rainbow, TextBlock textBlock) {
            super(FtileRepeat.this.repeat, FtileRepeat.this.diamond2);
            this.arrowColor = rainbow;
            this.tbout = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateForRepeat(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileRepeat.this.getTranslateDiamond2(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            if (!this.getFtile1().calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.tbout);
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            if (!this.getFtile1().calculateDimension(stringBounder).hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor);
            snake.setLabel(this.tbout);
            Point2D point2D = uTranslate.getTranslated(this.getP1(stringBounder));
            Point2D point2D2 = uTranslate2.getTranslated(this.getP2(stringBounder));
            double d = (point2D.getY() + point2D2.getY()) / 2.0;
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), d);
            snake.addPoint(point2D2.getX(), d);
            uGraphic.draw(snake);
            Snake snake2 = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake2.addPoint(point2D2.getX(), d);
            snake2.addPoint(point2D2);
            uGraphic.draw(snake2);
        }
    }

    class ConnectionIn
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final TextBlock tbin;

        public ConnectionIn(Rainbow rainbow, TextBlock textBlock) {
            super(FtileRepeat.this.diamond1, FtileRepeat.this.repeat);
            this.arrowColor = rainbow;
            this.tbin = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return this.getFtile1().calculateDimension(stringBounder).translate(FtileRepeat.this.getTranslateDiamond1(stringBounder)).getPointOut();
        }

        private Point2D getP2(StringBounder stringBounder) {
            return this.getFtile2().calculateDimension(stringBounder).translate(FtileRepeat.this.getTranslateForRepeat(stringBounder)).getPointIn();
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.setLabel(this.tbin);
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }
    }
}

