/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.MergeStrategy;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondFoo1;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileWhile
extends AbstractFtile {
    private final Ftile whileBlock;
    private final Ftile diamond1;
    private final Ftile specialOut;

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>(this.whileBlock.getSwimlanes());
        hashSet.add(this.getSwimlaneIn());
        return hashSet;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    private FtileWhile(Ftile ftile, Ftile ftile2, Ftile ftile3) {
        super(ftile.skinParam());
        this.whileBlock = ftile;
        this.diamond1 = ftile2;
        this.specialOut = ftile3;
    }

    public static Ftile create(Swimlane swimlane, Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, Rainbow rainbow, Display display2, Display display3, Rainbow rainbow2, LinkRendering linkRendering, FontConfiguration fontConfiguration, FtileFactory ftileFactory, ConditionStyle conditionStyle, FontConfiguration fontConfiguration2, Instruction instruction) {
        AbstractFtile abstractFtile;
        TextBlock textBlock = display2.create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        TextBlock textBlock2 = display.create(fontConfiguration2, ftile.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), ftileFactory.skinParam());
        TextBlock textBlock3 = display3.create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        if (conditionStyle == ConditionStyle.INSIDE) {
            abstractFtile = new FtileDiamondInside(ftile.skinParam(), htmlColor2, htmlColor, swimlane, textBlock2).withNorth(textBlock).withWest(textBlock3);
        } else if (conditionStyle == ConditionStyle.FOO1) {
            abstractFtile = new FtileDiamondFoo1(ftile.skinParam(), htmlColor2, htmlColor, swimlane, textBlock2).withNorth(textBlock).withWest(textBlock3);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            abstractFtile = new FtileDiamond(ftile.skinParam(), htmlColor2, htmlColor, swimlane).withNorth(textBlock2).withSouth(textBlock).withWest(textBlock3);
        } else {
            throw new IllegalStateException();
        }
        Ftile ftile2 = instruction == null ? null : instruction.createFtile(ftileFactory);
        FtileWhile ftileWhile = new FtileWhile(ftile, abstractFtile, ftile2);
        Rainbow rainbow3 = rainbow;
        if (linkRendering != null && linkRendering.getRainbow() != null && linkRendering.getRainbow().size() != 0) {
            rainbow3 = linkRendering.getRainbow();
        }
        FtileGeometry ftileGeometry = ftile.calculateDimension(ftileFactory.getStringBounder());
        Display display4 = ftile.getOutLinkRendering().getDisplay();
        TextBlock textBlock4 = display4.create(fontConfiguration, HorizontalAlignment.LEFT, ftileFactory.skinParam());
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        if (((Dimension2D)ftileGeometry).getWidth() == 0.0 || ((Dimension2D)ftileGeometry).getHeight() == 0.0) {
            FtileWhile ftileWhile2 = ftileWhile;
            ftileWhile2.getClass();
            arrayList.add(ftileWhile2.new ConnectionBackEmpty(rainbow2));
        } else {
            FtileWhile ftileWhile3 = ftileWhile;
            ftileWhile3.getClass();
            arrayList.add(ftileWhile3.new ConnectionIn(ftile.getInLinkRendering().getRainbow(rainbow)));
            FtileWhile ftileWhile4 = ftileWhile;
            ftileWhile4.getClass();
            arrayList.add(ftileWhile4.new ConnectionBack(rainbow2, textBlock4));
        }
        if (instruction == null) {
            FtileWhile ftileWhile5 = ftileWhile;
            ftileWhile5.getClass();
            arrayList.add(ftileWhile5.new ConnectionOut(rainbow3));
        } else {
            FtileWhile ftileWhile6 = ftileWhile;
            ftileWhile6.getClass();
            arrayList.add(ftileWhile6.new ConnectionOutSpecial(rainbow3));
        }
        return FtileUtils.addConnection((Ftile)ftileWhile, arrayList);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateForWhile(stringBounder)).draw(this.whileBlock);
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        if (this.specialOut != null) {
            uGraphic.apply(this.getTranslateForSpecial(stringBounder)).draw(this.specialOut);
        }
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.whileBlock.calculateDimension(stringBounder);
        double d = -ftileGeometry2.getWidth();
        if (d > 0.0) {
            ftileGeometry2 = ftileGeometry2.addMarginX(d / 2.0);
            assert (false);
        }
        FtileGeometry ftileGeometry3 = ftileGeometry.appendBottom(ftileGeometry2);
        double d2 = ftileGeometry3.getHeight() + 48.0;
        return new FtileGeometry(this.xDeltaBecauseSpecial(stringBounder) + ftileGeometry3.getWidth() + 24.0 + 12.0, d2, this.xDeltaBecauseSpecial(stringBounder) + ftileGeometry3.getLeft() + 24.0, ftileGeometry.getInY(), d2);
    }

    private double xDeltaBecauseSpecial(StringBounder stringBounder) {
        if (this.specialOut == null) {
            return 0.0;
        }
        return this.specialOut.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.whileBlock) {
            return this.getTranslateForWhile(stringBounder);
        }
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForWhile(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.whileBlock.calculateDimension(stringBounder);
        double d = ftileGeometry.getHeight() + (ftileGeometry2.getHeight() - ftileGeometry.getHeight() - ftileGeometry3.getHeight()) / 2.0;
        double d2 = ftileGeometry2.getLeft() - ftileGeometry3.getLeft();
        return new UTranslate(d2, d);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond1.calculateDimension(stringBounder);
        double d = ftileGeometry.getLeft() - ftileGeometry2.getLeft();
        return new UTranslate(d, 0.0);
    }

    private UTranslate getTranslateForSpecial(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        double d = (ftileGeometry.getOutY() - ftileGeometry.getInY()) / 2.0;
        double d2 = Math.max(3.0 * d, 48.0);
        double d3 = this.getTranslateForWhile(stringBounder).getDx() - this.xDeltaBecauseSpecial(stringBounder);
        return new UTranslate(d3, d2);
    }

    class ConnectionOutSpecial
    extends AbstractConnection {
        private final Rainbow afterEndwhileColor;

        public ConnectionOutSpecial(Rainbow rainbow) {
            super(FtileWhile.this.diamond1, FtileWhile.this.specialOut);
            this.afterEndwhileColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateForSpecial(stringBounder).getTranslated(FtileWhile.this.specialOut.calculateDimension(stringBounder).getPointIn());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.afterEndwhileColor, Arrows.asToDown());
            FtileGeometry ftileGeometry = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = (ftileGeometry.getOutY() - ftileGeometry.getInY()) / 2.0;
            double d3 = point2D.getY() + ftileGeometry.getInY() + d2;
            double d4 = point2D2.getX();
            double d5 = point2D2.getY();
            snake.addPoint(d, d3);
            snake.addPoint(d4, d3);
            snake.addPoint(d4, d5);
            uGraphic.draw(snake);
        }
    }

    class ConnectionOut
    extends AbstractConnection {
        private final Rainbow afterEndwhileColor;

        public ConnectionOut(Rainbow rainbow) {
            super(FtileWhile.this.diamond1, null);
            this.afterEndwhileColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileWhile.this.calculateDimension(stringBounder);
            return new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getHeight());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.afterEndwhileColor);
            FtileGeometry ftileGeometry = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = (ftileGeometry.getOutY() - ftileGeometry.getInY()) / 2.0;
            double d3 = point2D.getY() + ftileGeometry.getInY() + d2;
            double d4 = point2D2.getX();
            double d5 = point2D2.getY();
            snake.addPoint(d, d3);
            snake.addPoint(12.0, d3);
            snake.addPoint(12.0, d5);
            snake.emphasizeDirection(Direction.DOWN);
            snake.goUnmergeable(MergeStrategy.LIMITED);
            uGraphic.draw(snake);
            Snake snake2 = new Snake(this.arrowHorizontalAlignment(), this.afterEndwhileColor);
            snake2.addPoint(12.0, d5);
            snake2.addPoint(d4, d5);
            uGraphic.draw(snake2);
        }
    }

    class ConnectionBackEmpty
    extends AbstractConnection {
        private final Rainbow endInlinkColor;

        public ConnectionBackEmpty(Rainbow rainbow) {
            super(FtileWhile.this.diamond1, FtileWhile.this.diamond1);
            this.endInlinkColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(FtileWhile.this.diamond1.calculateDimension(stringBounder).getPointOut());
        }

        private double getBottom(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            return FtileWhile.this.getTranslateForWhile(stringBounder).getDy() + ftileGeometry.getHeight();
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.endInlinkColor, Arrows.asToLeft());
            FtileGeometry ftileGeometry = FtileWhile.this.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry2 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX() + ftileGeometry2.getWidth();
            double d4 = (ftileGeometry2.getOutY() - ftileGeometry2.getInY()) / 2.0;
            double d5 = point2D2.getY() + ftileGeometry2.getInY() + d4;
            snake.addPoint(d, d2);
            double d6 = Math.max(d2, this.getBottom(stringBounder)) + 12.0;
            snake.addPoint(d, d6);
            double d7 = ((Dimension2D)ftileGeometry).getWidth();
            snake.addPoint(d7, d6);
            snake.addPoint(d7, d5);
            snake.addPoint(d3, d5);
            snake.emphasizeDirection(Direction.UP);
            uGraphic.draw(snake);
            uGraphic.apply(new UTranslate(d, d6)).draw(new UEmpty(5.0, 12.0));
        }
    }

    class ConnectionBack
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow endInlinkColor;
        private final TextBlock back;

        public ConnectionBack(Rainbow rainbow, TextBlock textBlock) {
            super(FtileWhile.this.whileBlock, FtileWhile.this.diamond1);
            this.endInlinkColor = rainbow;
            this.back = textBlock;
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return null;
            }
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(ftileGeometry.getPointOut());
        }

        private double getBottom(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            return FtileWhile.this.getTranslateForWhile(stringBounder).getDy() + ftileGeometry.getHeight();
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.endInlinkColor, Arrows.asToLeft());
            FtileGeometry ftileGeometry = FtileWhile.this.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry2 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX() + ftileGeometry2.getWidth();
            double d4 = (ftileGeometry2.getOutY() - ftileGeometry2.getInY()) / 2.0;
            double d5 = point2D2.getY() + ftileGeometry2.getInY() + d4;
            snake.setLabel(this.back);
            snake.addPoint(d, d2);
            double d6 = Math.max(d2, this.getBottom(stringBounder)) + 12.0;
            snake.addPoint(d, d6);
            double d7 = ((Dimension2D)ftileGeometry).getWidth();
            snake.addPoint(d7, d6);
            snake.addPoint(d7, d5);
            snake.addPoint(d3, d5);
            snake.emphasizeDirection(Direction.UP);
            uGraphic.draw(snake);
            uGraphic.apply(new UTranslate(d, d6)).draw(new UEmpty(5.0, 12.0));
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.endInlinkColor, Arrows.asToLeft());
            FtileGeometry ftileGeometry = FtileWhile.this.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            FtileGeometry ftileGeometry2 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double d = point2D3.getX();
            double d2 = point2D3.getY();
            double d3 = point2D4.getX() + ((Dimension2D)ftileGeometry2).getWidth();
            double d4 = point2D4.getY() + ((Dimension2D)ftileGeometry2).getHeight() / 2.0;
            snake.addPoint(d, d2);
            snake.addPoint(d, d2 + 12.0);
            double d5 = Math.max(uTranslate.getDx(), uTranslate2.getDx()) + ((Dimension2D)ftileGeometry).getWidth();
            snake.addPoint(d5, d2 + 12.0);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            snake.goUnmergeable(MergeStrategy.LIMITED);
            uGraphic.draw(snake);
            uGraphic.apply(new UTranslate(d, d2 + 12.0)).draw(new UEmpty(5.0, 12.0));
            uGraphic = uGraphic.apply(new UChangeColor(this.endInlinkColor.getColor())).apply(new UChangeBackColor(this.endInlinkColor.getColor()));
            uGraphic.apply(new UTranslate(d5, (d2 + d4) / 2.0)).draw(Arrows.asToUp());
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final Rainbow arrowColor;

        public ConnectionIn(Rainbow rainbow) {
            super(FtileWhile.this.diamond1, FtileWhile.this.whileBlock);
            this.arrowColor = rainbow;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            double d = (point2D3.getY() + point2D4.getY()) / 2.0;
            snake.addPoint(point2D3);
            snake.addPoint(point2D3.getX(), d);
            snake.addPoint(point2D4.getX(), d);
            snake.addPoint(point2D4);
            snake.goUnmergeable(MergeStrategy.LIMITED);
            uGraphic.draw(snake);
        }
    }
}

