/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ParallelFtilesBuilder;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBlackBlock;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelBuilderFork
extends ParallelFtilesBuilder {
    private final String label;

    public ParallelBuilderFork(ISkinParam iSkinParam, StringBounder stringBounder, List<Ftile> list, Ftile ftile, Swimlane swimlane, String string) {
        super(iSkinParam, stringBounder, list, ftile, swimlane);
        this.label = string;
    }

    @Override
    protected Ftile doStep1() {
        Ftile ftile = this.getMiddle();
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        FtileBlackBlock ftileBlackBlock = new FtileBlackBlock(this.skinParam(), this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityBar), this.getList().get(0).getSwimlaneIn());
        double d = 0.0;
        for (Ftile ftile2 : this.getList()) {
            FtileGeometry ftileGeometry = ftile2.calculateDimension(this.getStringBounder());
            arrayList.add(new ConnectionIn(ftileBlackBlock, ftile2, d, ftile2.getInLinkRendering().getRainbow(HtmlColorAndStyle.build(this.skinParam()))));
            d += ((Dimension2D)ftileGeometry).getWidth();
        }
        ftile = FtileUtils.addConnection(ftile, arrayList);
        ftileBlackBlock.setBlackBlockDimension(ftile.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        return new FtileAssemblySimple(ftileBlackBlock, ftile);
    }

    @Override
    protected Ftile doStep2(Ftile ftile) {
        FtileBlackBlock ftileBlackBlock = new FtileBlackBlock(this.skinParam(), this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityBar), this.getList().get(0).getSwimlaneIn());
        ftileBlackBlock.setBlackBlockDimension(ftile.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        if (this.label != null) {
            ftileBlackBlock.setLabel(this.getTextBlock(Display.getWithNewlines(this.label)));
        }
        ftile = new FtileAssemblySimple(ftile, ftileBlackBlock);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        double d = 0.0;
        for (Ftile ftile2 : this.getList()) {
            UTranslate uTranslate = new UTranslate(0.0, 6.0);
            FtileGeometry ftileGeometry = ftile2.calculateDimension(this.getStringBounder());
            arrayList.add(new ConnectionOut(uTranslate, ftile2, ftileBlackBlock, d, ftile2.getOutLinkRendering().getRainbow(HtmlColorAndStyle.build(this.skinParam())), this.getHeightOfMiddle()));
            d += ((Dimension2D)ftileGeometry).getWidth();
        }
        ftile = FtileUtils.addConnection(ftile, arrayList);
        return ftile;
    }

    class ConnectionOut
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final double height;
        private final Display label;
        private final UTranslate translate0;

        public ConnectionOut(UTranslate uTranslate, Ftile ftile, Ftile ftile2, double d, Rainbow rainbow, double d2) {
            super(ftile, ftile2);
            this.translate0 = uTranslate;
            this.label = ftile.getOutLinkRendering().getDisplay();
            this.x = d;
            this.arrowColor = rainbow;
            this.height = d2;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            Point2D point2D = this.translate0.getTranslated(new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getOutY()));
            Point2D point2D2 = this.translate0.getTranslated(new Point2D.Double(ftileGeometry.getLeft(), this.height));
            snake.addPoint(point2D);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile1().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            if (!ftileGeometry.hasPointOut()) {
                return;
            }
            Point2D point2D = this.translate0.getTranslated(new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getOutY()));
            Point2D point2D2 = this.translate0.getTranslated(new Point2D.Double(ftileGeometry.getLeft(), this.height));
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            double d = point2D4.getY() - 14.0;
            snake.addPoint(point2D3);
            snake.addPoint(point2D3.getX(), d);
            snake.addPoint(point2D4.getX(), d);
            snake.addPoint(point2D4);
            uGraphic.draw(snake);
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final Display label;

        public ConnectionIn(Ftile ftile, Ftile ftile2, double d, Rainbow rainbow) {
            super(ftile, ftile2);
            this.label = ftile2.getInLinkRendering().getDisplay();
            this.x = d;
            this.arrowColor = rainbow;
        }

        public void drawU(UGraphic uGraphic) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            snake.addPoint(ftileGeometry.getLeft(), 0.0);
            snake.addPoint(ftileGeometry.getLeft(), ftileGeometry.getInY());
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            uGraphic = uGraphic.apply(new UTranslate(this.x, 0.0));
            FtileGeometry ftileGeometry = this.getFtile2().calculateDimension(ParallelBuilderFork.this.getStringBounder());
            Point2D.Double double_ = new Point2D.Double(ftileGeometry.getLeft(), 0.0);
            Point2D.Double double_2 = new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getInY());
            Snake snake = new Snake(this.arrowHorizontalAlignment(), this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake.setLabel(ParallelBuilderFork.this.getTextBlock(this.label));
            }
            Point2D point2D = uTranslate.getTranslated(double_);
            Point2D point2D2 = uTranslate2.getTranslated(double_2);
            double d = point2D.getY() + 4.0;
            snake.addPoint(point2D);
            snake.addPoint(point2D.getX(), d);
            snake.addPoint(point2D2.getX(), d);
            snake.addPoint(point2D2);
            uGraphic.draw(snake);
        }
    }
}

