/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileBlackBlock
extends AbstractFtile {
    private final double labelMargin = 5.0;
    private double width;
    private double height;
    private TextBlock label = TextBlockUtils.empty(0.0, 0.0);
    private final HtmlColor colorBar;
    private final Swimlane swimlane;

    public FtileBlackBlock(ISkinParam iSkinParam, HtmlColor htmlColor, Swimlane swimlane) {
        super(iSkinParam);
        this.colorBar = htmlColor;
        this.swimlane = swimlane;
    }

    public void setBlackBlockDimension(double d, double d2) {
        this.height = d2;
        this.width = d;
    }

    public void setLabel(TextBlock textBlock) {
        if (textBlock == null) {
            throw new IllegalArgumentException();
        }
        this.label = textBlock;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        double d = this.label.calculateDimension(stringBounder).getWidth();
        if (d > 0.0) {
            d += 5.0;
        }
        return new FtileGeometry(this.width + d, this.height, this.width / 2.0, 0.0, this.height);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        URectangle uRectangle = new URectangle(this.width, this.height, 5.0, 5.0);
        if (this.skinParam().shadowing()) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.apply(new UChangeColor(this.colorBar)).apply(new UChangeBackColor(this.colorBar)).draw(uRectangle);
        Dimension2D dimension2D = this.label.calculateDimension(uGraphic.getStringBounder());
        this.label.drawU(uGraphic.apply(new UTranslate(this.width + 5.0, -dimension2D.getHeight() / 2.0)));
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }
}

