/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileThinSplit
extends AbstractFtile {
    private double width;
    private double first;
    private double last;
    private final double height = 1.5;
    private final HtmlColor colorBar;
    private final Swimlane swimlane;

    public FtileThinSplit(ISkinParam iSkinParam, HtmlColor htmlColor, Swimlane swimlane) {
        super(iSkinParam);
        this.colorBar = htmlColor;
        this.swimlane = swimlane;
    }

    public void setGeom(double d, double d2, double d3) {
        this.width = d3;
        this.first = d;
        this.last = d2;
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        return new FtileGeometry(this.width, 1.5, this.width / 2.0, 0.0, 1.5);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        ULine uLine = new ULine(this.last - this.first, 0.0);
        uGraphic = uGraphic.apply(new UTranslate(this.first, 0.0));
        uGraphic.apply(new UChangeColor(this.colorBar)).apply(new UStroke(1.5)).draw(uLine);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }
}

