/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.api.INumberAnalyzed;

public class NumberAnalyzed
implements INumberAnalyzed {
    private static final int SLIDING_WINDOW = 512;
    private long nb;
    private long sum;
    private long min;
    private long max;
    private long sumOfSquare;
    private long sliddingSum;
    private final String name;
    private final Lock saveLock = new ReentrantLock();

    public NumberAnalyzed(String string) {
        this.name = string;
    }

    public synchronized void reset() {
        this.nb = 0L;
        this.sum = 0L;
        this.min = 0L;
        this.max = 0L;
        this.sumOfSquare = 0L;
        this.sliddingSum = 0L;
    }

    public NumberAnalyzed() {
        this("");
    }

    public final void save(Preferences preferences) {
        if (this.name.length() == 0) {
            throw new UnsupportedOperationException();
        }
        if (this.saveLock.tryLock()) {
            try {
                preferences.put(this.name + ".saved", this.getSavedString());
            }
            finally {
                this.saveLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSavedString() {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        NumberAnalyzed numberAnalyzed = this;
        synchronized (numberAnalyzed) {
            l6 = this.nb;
            l5 = this.sum;
            l4 = this.min;
            l3 = this.max;
            l2 = this.sumOfSquare;
            l = this.sliddingSum;
        }
        String string = this.getSavedSupplementatyData();
        return this.longToString(l6) + ";" + this.longToString(l5) + ";" + this.longToString(l4) + ";" + this.longToString(l3) + ";" + this.longToString(l2) + ";" + this.longToString(l) + ";" + string + ";";
    }

    protected String getSavedSupplementatyData() {
        return "";
    }

    protected final String longToString(long l) {
        return Long.toString(l, 36);
    }

    public static NumberAnalyzed load(String string, Preferences preferences) {
        String string2 = preferences.get(string + ".saved", "");
        if (string2.length() == 0) {
            Log.info("Cannot load " + string);
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            return new NumberAnalyzed(string, Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.info("Error reading " + string2);
            return null;
        }
    }

    public synchronized String toString() {
        return "sum=" + this.sum + " nb=" + this.nb + " min=" + this.min + " max=" + this.max + " mean=" + this.getMean();
    }

    protected NumberAnalyzed(String string, long l, long l2, long l3, long l4, long l5, long l6) {
        this(string);
        this.nb = l;
        this.sum = l2;
        this.min = l3;
        this.max = l4;
        this.sumOfSquare = l5;
        this.sliddingSum = l6;
    }

    public synchronized INumberAnalyzed getCopyImmutable() {
        NumberAnalyzed numberAnalyzed = new NumberAnalyzed(this.name, this.nb, this.sum, this.min, this.max, this.sumOfSquare, this.sliddingSum);
        return numberAnalyzed;
    }

    public synchronized void addValue(long l) {
        ++this.nb;
        if (this.nb == 1L) {
            this.min = l;
            this.max = l;
        } else if (l > this.max) {
            this.max = l;
        } else if (l < this.min) {
            this.min = l;
        }
        this.sum += l;
        this.sumOfSquare += l * l;
        this.sliddingSum = this.sliddingSum * 511L / 512L + l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NumberAnalyzed numberAnalyzed) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        NumberAnalyzed numberAnalyzed2 = numberAnalyzed;
        synchronized (numberAnalyzed2) {
            l6 = numberAnalyzed.nb;
            l5 = numberAnalyzed.sum;
            l4 = numberAnalyzed.min;
            l3 = numberAnalyzed.max;
            l2 = numberAnalyzed.sumOfSquare;
            l = numberAnalyzed.sliddingSum;
        }
        numberAnalyzed2 = this;
        synchronized (numberAnalyzed2) {
            this.sum += l5;
            this.nb += l6;
            this.min = Math.min(this.min, l4);
            this.max = Math.max(this.max, l3);
            this.sumOfSquare += l2;
            this.sliddingSum += l;
        }
    }

    public final synchronized long getNb() {
        return this.nb;
    }

    public final synchronized long getSum() {
        return this.sum;
    }

    public final synchronized long getMin() {
        return this.min;
    }

    public final synchronized long getMax() {
        return this.max;
    }

    public final synchronized long getMean() {
        if (this.nb == 0L) {
            return 0L;
        }
        return this.sum / this.nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getStandardDeviation() {
        long l;
        long l2;
        long l3;
        NumberAnalyzed numberAnalyzed = this;
        synchronized (numberAnalyzed) {
            l3 = this.sum;
            l2 = this.sumOfSquare;
            l = this.nb;
        }
        if (l == 0L) {
            return 0L;
        }
        long l4 = l3 / l;
        return Math.round(Math.sqrt(l2 / l - l4 * l4));
    }

    public final String getName() {
        return this.name;
    }
}

