/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.api;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.prefs.Preferences;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.api.INumberAnalyzed;

public class NumberAnalyzed2
implements INumberAnalyzed {
    private static final int SLIDING_WINDOW = 512;
    private final AtomicLong nb = new AtomicLong();
    private final AtomicLong sum = new AtomicLong();
    private final AtomicLong min = new AtomicLong();
    private final AtomicLong max = new AtomicLong();
    private final AtomicLong sumOfSquare = new AtomicLong();
    private final AtomicLong sliddingSum = new AtomicLong();
    private final String name;

    public NumberAnalyzed2(String string) {
        this.name = string;
    }

    public void reset() {
        this.nb.set(0L);
        this.sum.set(0L);
        this.min.set(0L);
        this.max.set(0L);
        this.sumOfSquare.set(0L);
        this.sliddingSum.set(0L);
    }

    public NumberAnalyzed2() {
        this("");
    }

    public final void save(Preferences preferences) {
        if (this.name.length() == 0) {
            throw new UnsupportedOperationException();
        }
        preferences.put(this.name + ".saved", this.getSavedString());
    }

    protected String getSavedString() {
        String string = this.longToString(this.nb) + ";" + this.longToString(this.sum) + ";" + this.longToString(this.min) + ";" + this.longToString(this.max) + ";" + this.longToString(this.sumOfSquare) + ";" + this.longToString(this.sliddingSum);
        return string;
    }

    protected final String longToString(AtomicLong atomicLong) {
        return Long.toString(atomicLong.get(), 36);
    }

    public static NumberAnalyzed2 load(String string, Preferences preferences) {
        String string2 = preferences.get(string + ".saved", "");
        if (string2.length() == 0) {
            System.err.println("Cannot load " + string);
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            return new NumberAnalyzed2(string, Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36), Long.parseLong(stringTokenizer.nextToken(), 36));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.info("Error reading " + string2);
            return null;
        }
    }

    public String toString() {
        return "sum=" + this.sum + " nb=" + this.nb + " min=" + this.min + " max=" + this.max + " mean=" + this.getMean();
    }

    protected NumberAnalyzed2(String string, long l, long l2, long l3, long l4, long l5, long l6) {
        this(string);
        this.nb.set(l);
        this.sum.set(l2);
        this.min.set(l3);
        this.max.set(l4);
        this.sumOfSquare.set(l5);
        this.sliddingSum.set(l6);
    }

    public INumberAnalyzed getCopyImmutable() {
        NumberAnalyzed2 numberAnalyzed2 = new NumberAnalyzed2(this.name, this.nb.get(), this.sum.get(), this.min.get(), this.max.get(), this.sumOfSquare.get(), this.sliddingSum.get());
        return numberAnalyzed2;
    }

    public void addValue(long l) {
        this.nb.incrementAndGet();
        if (this.nb.get() == 1L) {
            this.min.set(l);
            this.max.set(l);
        } else if (l > this.max.get()) {
            this.max.set(l);
        } else if (l < this.min.get()) {
            this.min.set(l);
        }
        this.sum.addAndGet(l);
        this.sumOfSquare.addAndGet(l * l);
        this.sliddingSum.set(this.sliddingSum.get() * 511L / 512L + l);
    }

    public void add(NumberAnalyzed2 numberAnalyzed2) {
        this.sum.addAndGet(numberAnalyzed2.sum.get());
        this.nb.addAndGet(numberAnalyzed2.nb.get());
        this.min.set(Math.min(this.min.get(), numberAnalyzed2.min.get()));
        this.max.set(Math.max(this.max.get(), numberAnalyzed2.max.get()));
    }

    public final long getNb() {
        return this.nb.get();
    }

    public final long getSum() {
        return this.sum.get();
    }

    public final long getMin() {
        return this.min.get();
    }

    public final long getMax() {
        return this.max.get();
    }

    public final long getMean() {
        if (this.nb.get() == 0L) {
            return 0L;
        }
        return this.sum.get() / this.nb.get();
    }

    public final String getName() {
        return this.name;
    }
}

