/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.asciiart.BasicCharArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AsciiShape {
    STICKMAN(3, 5),
    STICKMAN_UNICODE(3, 6),
    BOUNDARY(8, 3),
    DATABASE(10, 6);

    private final int width;
    private final int height;

    private AsciiShape(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    public void draw(BasicCharArea basicCharArea, int n, int n2) {
        if (this == STICKMAN) {
            this.drawStickMan(basicCharArea, n, n2);
        } else if (this == STICKMAN_UNICODE) {
            this.drawStickManUnicode(basicCharArea, n, n2);
        } else if (this == BOUNDARY) {
            this.drawBoundary(basicCharArea, n, n2);
        } else if (this == DATABASE) {
            this.drawDatabase(basicCharArea, n, n2);
        }
    }

    private void drawDatabase(BasicCharArea basicCharArea, int n, int n2) {
        basicCharArea.drawStringLR(" ,.-^^-._", n, n2++);
        basicCharArea.drawStringLR("|-.____.-|", n, n2++);
        basicCharArea.drawStringLR("|        |", n, n2++);
        basicCharArea.drawStringLR("|        |", n, n2++);
        basicCharArea.drawStringLR("|        |", n, n2++);
        basicCharArea.drawStringLR("'-.____.-'", n, n2++);
    }

    private void drawDatabaseSmall(BasicCharArea basicCharArea, int n, int n2) {
        basicCharArea.drawStringLR(" ,.-\"-._ ", n, n2++);
        basicCharArea.drawStringLR("|-.___.-|", n, n2++);
        basicCharArea.drawStringLR("|       |", n, n2++);
        basicCharArea.drawStringLR("|       |", n, n2++);
        basicCharArea.drawStringLR("|       |", n, n2++);
        basicCharArea.drawStringLR("'-.___.-'", n, n2++);
    }

    private void drawBoundary(BasicCharArea basicCharArea, int n, int n2) {
        basicCharArea.drawStringLR("|   ,-.", n, n2++);
        basicCharArea.drawStringLR("+--{   )", n, n2++);
        basicCharArea.drawStringLR("|   `-'", n, n2++);
    }

    private void drawStickMan(BasicCharArea basicCharArea, int n, int n2) {
        basicCharArea.drawStringLR(",-.", n, n2++);
        basicCharArea.drawStringLR("`-'", n, n2++);
        basicCharArea.drawStringLR("/|\\", n, n2++);
        basicCharArea.drawStringLR(" | ", n, n2++);
        basicCharArea.drawStringLR("/ \\", n, n2++);
    }

    private void drawStickManUnicode(BasicCharArea basicCharArea, int n, int n2) {
        basicCharArea.drawStringLR("\u250c\u2500\u2510", n, n2++);
        basicCharArea.drawStringLR("\u2551\"\u2502", n, n2++);
        basicCharArea.drawStringLR("\u2514\u252c\u2518", n, n2++);
        basicCharArea.drawStringLR("\u250c\u253c\u2510", n, n2++);
        basicCharArea.drawStringLR(" \u2502 ", n, n2++);
        basicCharArea.drawStringLR("\u250c\u2534\u2510", n, n2++);
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }
}

