/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextLine
extends AbstractComponentText {
    private static final int MAGIC_NUMBER = -3;
    private char using;

    public ComponentTextLine(ComponentType componentType, FileFormat fileFormat) {
        this.using = fileFormat == FileFormat.UTXT ? (char)9474 : (char)124;
        if (componentType == ComponentType.DELAY_LINE) {
            this.using = (char)46;
        }
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        umlCharArea.drawVLine(this.using, (n - 1) / 2, -3, n2);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return 3.0;
    }
}

