/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.AsciiShape;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextShape
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final AsciiShape shape;

    public ComponentTextShape(ComponentType componentType, Display display, AsciiShape asciiShape) {
        this.type = componentType;
        this.stringsToDisplay = display;
        this.shape = asciiShape;
    }

    public void drawU(UGraphic uGraphic, Area area, Context2D context2D) {
        Dimension2D dimension2D = area.getDimensionToUse();
        UmlCharArea umlCharArea = ((UGraphicTxt)uGraphic).getCharArea();
        int n = (int)dimension2D.getWidth();
        int n2 = (int)dimension2D.getHeight();
        umlCharArea.fillRect(' ', 0, 0, n, n2);
        int n3 = n / 2 - this.shape.getWidth() / 2 + 1;
        if (this.type.name().endsWith("_HEAD")) {
            umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 1, this.getHeight());
            umlCharArea.drawShape(this.shape, n3, 0);
        } else {
            umlCharArea.drawStringsLR(this.stringsToDisplay.as(), 1, 0);
            umlCharArea.drawShape(this.shape, n3, 1);
        }
    }

    private int getHeight() {
        return this.shape.getHeight();
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + this.getHeight();
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWidth(this.stringsToDisplay) + 2;
    }
}

