/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.asciiart.AsciiShape;
import net.sourceforge.plantuml.asciiart.ComponentTextActiveLine;
import net.sourceforge.plantuml.asciiart.ComponentTextActor;
import net.sourceforge.plantuml.asciiart.ComponentTextArrow;
import net.sourceforge.plantuml.asciiart.ComponentTextDelay;
import net.sourceforge.plantuml.asciiart.ComponentTextDestroy;
import net.sourceforge.plantuml.asciiart.ComponentTextDivider;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingElse;
import net.sourceforge.plantuml.asciiart.ComponentTextGroupingHeader;
import net.sourceforge.plantuml.asciiart.ComponentTextLine;
import net.sourceforge.plantuml.asciiart.ComponentTextNewpage;
import net.sourceforge.plantuml.asciiart.ComponentTextNote;
import net.sourceforge.plantuml.asciiart.ComponentTextParticipant;
import net.sourceforge.plantuml.asciiart.ComponentTextSelfArrow;
import net.sourceforge.plantuml.asciiart.ComponentTextShape;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.skin.rose.ComponentRoseGroupingSpace;

public class TextSkin
implements Skin {
    private final FileFormat fileFormat;

    public TextSkin(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Component createComponent(ComponentType componentType, ArrowConfiguration arrowConfiguration, ISkinParam iSkinParam, Display display) {
        if (componentType == ComponentType.ACTOR_HEAD || componentType == ComponentType.ACTOR_TAIL) {
            return new ComponentTextActor(componentType, display, this.fileFormat, this.fileFormat == FileFormat.UTXT ? AsciiShape.STICKMAN_UNICODE : AsciiShape.STICKMAN);
        }
        if (componentType == ComponentType.BOUNDARY_HEAD || componentType == ComponentType.BOUNDARY_TAIL) {
            return new ComponentTextShape(componentType, display, AsciiShape.BOUNDARY);
        }
        if (componentType == ComponentType.DATABASE_HEAD || componentType == ComponentType.DATABASE_TAIL) {
            return new ComponentTextShape(componentType, display, AsciiShape.DATABASE);
        }
        if (componentType.name().endsWith("_HEAD") || componentType.name().endsWith("_TAIL")) {
            return new ComponentTextParticipant(componentType, display, this.fileFormat);
        }
        if (componentType.isArrow() && (arrowConfiguration.getArrowDirection() == ArrowDirection.LEFT_TO_RIGHT_NORMAL || arrowConfiguration.getArrowDirection() == ArrowDirection.RIGHT_TO_LEFT_REVERSE || arrowConfiguration.getArrowDirection() == ArrowDirection.BOTH_DIRECTION)) {
            return new ComponentTextArrow(componentType, arrowConfiguration, display, this.fileFormat, iSkinParam.maxAsciiMessageLength());
        }
        if (componentType.isArrow() && arrowConfiguration.isSelfArrow()) {
            return new ComponentTextSelfArrow(componentType, arrowConfiguration, display, this.fileFormat);
        }
        if (componentType == ComponentType.PARTICIPANT_LINE) {
            return new ComponentTextLine(componentType, this.fileFormat);
        }
        if (componentType == ComponentType.CONTINUE_LINE) {
            return new ComponentTextLine(componentType, this.fileFormat);
        }
        if (componentType == ComponentType.DELAY_LINE) {
            return new ComponentTextLine(componentType, this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_CLOSE_OPEN) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_CLOSE) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.ALIVE_BOX_OPEN_OPEN) {
            return new ComponentTextActiveLine(this.fileFormat);
        }
        if (componentType == ComponentType.NOTE || componentType == ComponentType.NOTE_BOX) {
            return new ComponentTextNote(componentType, display, this.fileFormat);
        }
        if (componentType == ComponentType.DIVIDER) {
            return new ComponentTextDivider(componentType, display, this.fileFormat);
        }
        if (componentType == ComponentType.GROUPING_HEADER) {
            return new ComponentTextGroupingHeader(componentType, display, this.fileFormat);
        }
        if (componentType == ComponentType.GROUPING_SPACE) {
            return new ComponentRoseGroupingSpace(1.0);
        }
        if (componentType == ComponentType.GROUPING_ELSE) {
            return new ComponentTextGroupingElse(componentType, display, this.fileFormat);
        }
        if (componentType == ComponentType.NEWPAGE) {
            return new ComponentTextNewpage(this.fileFormat);
        }
        if (componentType == ComponentType.DELAY_TEXT) {
            return new ComponentTextDelay(componentType, display, this.fileFormat);
        }
        if (componentType == ComponentType.DESTROY) {
            return new ComponentTextDestroy();
        }
        throw new UnsupportedOperationException(componentType.toString());
    }

    public Object getProtocolVersion() {
        return 1;
    }
}

