/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.bpm;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.bpm.Cell;
import net.sourceforge.plantuml.bpm.Placeable;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GridArray
implements UDrawable {
    private final int lines;
    private final int cols;
    private final Placeable[][] data;
    private final ISkinParam skinParam;
    private final double margin = 30.0;

    public GridArray(ISkinParam iSkinParam, int n, int n2) {
        this.skinParam = iSkinParam;
        this.lines = n;
        this.cols = n2;
        this.data = new Placeable[n][n2];
    }

    public String toString() {
        return "" + this.lines + "x" + this.cols;
    }

    public void setData(int n, int n2, Placeable placeable) {
        this.data[n][n2] = placeable;
    }

    public Placeable getData(int n, int n2) {
        return this.data[n][n2];
    }

    public final int getRows() {
        return this.cols;
    }

    public final int getLines() {
        return this.lines;
    }

    private double getHeightOfLine(StringBounder stringBounder, int n) {
        double d = 0.0;
        for (int i = 0; i < this.cols; ++i) {
            Placeable placeable = this.data[n][i];
            if (placeable == null) continue;
            d = Math.max(d, placeable.getDimension(stringBounder, this.skinParam).getHeight());
        }
        return d;
    }

    private double getWidthOfCol(StringBounder stringBounder, int n) {
        double d = 0.0;
        for (int i = 0; i < this.lines; ++i) {
            Placeable placeable = this.data[i][n];
            if (placeable == null) continue;
            d = Math.max(d, placeable.getDimension(stringBounder, this.skinParam).getWidth());
        }
        return d;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = 0.0;
        this.drawInternalGrid(uGraphic);
        for (int i = 0; i < this.lines; ++i) {
            double d2 = 0.0;
            double d3 = this.getHeightOfLine(stringBounder, i);
            for (int j = 0; j < this.cols; ++j) {
                double d4 = this.getWidthOfCol(stringBounder, j);
                Placeable placeable = this.data[i][j];
                if (placeable != null) {
                    Dimension2D dimension2D = placeable.getDimension(stringBounder, this.skinParam);
                    placeable.toTextBlock(this.skinParam).drawU(uGraphic.apply(new UTranslate(d2 + (d4 + 30.0 - dimension2D.getWidth()) / 2.0, d + (d3 + 30.0 - dimension2D.getHeight()) / 2.0)));
                }
                d2 += d4 + 30.0;
            }
            d += d3 + 30.0;
        }
    }

    private void drawInternalGrid(UGraphic uGraphic) {
        double d = 0.0;
        for (int i = 0; i < this.lines; ++i) {
            d += this.getHeightOfLine(uGraphic.getStringBounder(), i) + 30.0;
        }
        double d2 = 0.0;
        for (int i = 0; i < this.cols; ++i) {
            d2 += this.getWidthOfCol(uGraphic.getStringBounder(), i) + 30.0;
        }
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
        double d3 = 0.0;
        for (int i = 0; i < this.lines; ++i) {
            uGraphic.apply(new UTranslate(0.0, d3)).draw(new ULine(d2, 0.0));
            d3 += this.getHeightOfLine(uGraphic.getStringBounder(), i) + 30.0;
        }
        double d4 = 0.0;
        for (int i = 0; i < this.cols; ++i) {
            uGraphic.apply(new UTranslate(d4, 0.0)).draw(new ULine(0.0, d));
            d4 += this.getWidthOfCol(uGraphic.getStringBounder(), i) + 30.0;
        }
    }

    private void drawArrow(UGraphic uGraphic, Point2D point2D, Point2D point2D2) {
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLUE));
        ULine uLine = new ULine(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
        uGraphic.apply(new UTranslate(point2D)).draw(uLine);
    }

    private Point2D getCenterOf(StringBounder stringBounder, int n, int n2) {
        double d = this.getWidthOfCol(stringBounder, n) / 2.0 + 15.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.getWidthOfCol(stringBounder, i);
            d += d2 + 30.0;
        }
        double d3 = this.getHeightOfLine(stringBounder, n2) / 2.0 + 15.0;
        for (int i = 0; i < n2; ++i) {
            double d4 = this.getHeightOfLine(stringBounder, i);
            d3 += d4 + 30.0;
        }
        return new Point2D.Double(d, d3);
    }

    private int[] getCoord(Cell cell2) {
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                Placeable placeable = this.data[i][j];
                if (placeable != cell2.getData()) continue;
                return new int[]{j, i};
            }
        }
        throw new IllegalArgumentException();
    }

    private void printMe() {
        for (int i = 0; i < this.lines; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                Placeable placeable = this.data[i][j];
                System.err.print(placeable);
                System.err.print("  ;  ");
            }
            System.err.println();
        }
    }
}

