/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClass;
import net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.VisibilityModifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateClassMultilines
extends CommandMultilines2<ClassDiagram> {
    private static final String CODE = CommandLinkClass.getSeparator() + "?[\\p{L}0-9_]+(?:" + CommandLinkClass.getSeparator() + "[\\p{L}0-9_]+)*";
    public static final String CODES = CODE + "(?:\\s*,\\s*" + CODE + ")*";

    public CommandCreateClassMultilines() {
        super(CommandCreateClassMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^[%s]*\\}[%s]*$";
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("VISIBILITY", "(" + VisibilityModifier.regexForVisibilityCharacterInClassName() + ")?"), new RegexLeaf("TYPE", "(interface|enum|abstract[%s]+class|abstract|class|entity)[%s]+"), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", CommandCreateClass.DISPLAY_WITH_GENERIC), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("CODE1", "([^%s{}%g<>]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^%s{}%g<>]+)"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("DISPLAY2", CommandCreateClass.DISPLAY_WITH_GENERIC)), new RegexLeaf("CODE3", "([^%s{}%g<>]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), new RegexLeaf("GENERIC", "(?:[%s]*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandCreateClassMultilines.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("EXTENDS", "([%s]+(extends)[%s]+(" + CODES + "))?"), new RegexLeaf("IMPLEMENTS", "([%s]+(implements)[%s]+(" + CODES + "))?"), new RegexLeaf("[%s]*\\{[%s]*$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public CommandExecutionResult executeNow(ClassDiagram classDiagram, BlocLines blocLines) {
        blocLines = blocLines.trimSmart(1);
        blocLines = blocLines.removeComments();
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        IEntity iEntity = this.executeArg0(classDiagram, regexResult);
        if (iEntity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        if (blocLines.size() > 1) {
            blocLines = blocLines.subExtract(1, 1);
            Url url = null;
            for (CharSequence charSequence : blocLines) {
                if (charSequence.length() > 0 && VisibilityModifier.isVisibilityCharacter(charSequence)) {
                    classDiagram.setVisibilityModifierPresent(true);
                }
                iEntity.getBodier().addFieldOrMethod(charSequence.toString(), iEntity);
            }
            if (url != null) {
                iEntity.addUrl(url);
            }
        }
        CommandCreateClassMultilines.manageExtends("EXTENDS", classDiagram, regexResult, iEntity);
        CommandCreateClassMultilines.manageExtends("IMPLEMENTS", classDiagram, regexResult, iEntity);
        return CommandExecutionResult.ok();
    }

    public static void manageExtends(String string, ClassDiagram classDiagram, RegexResult regexResult, IEntity iEntity) {
        if (regexResult.get(string, 1) != null) {
            Mode mode = regexResult.get(string, 1).equalsIgnoreCase("extends") ? Mode.EXTENDS : Mode.IMPLEMENTS;
            LeafType leafType = LeafType.CLASS;
            if (mode == Mode.IMPLEMENTS) {
                leafType = LeafType.INTERFACE;
            }
            if (mode == Mode.EXTENDS && iEntity.getLeafType() == LeafType.INTERFACE) {
                leafType = LeafType.INTERFACE;
            }
            String string2 = regexResult.get(string, 2);
            for (String string3 : string2.split(",")) {
                Code code = Code.of(StringUtils.trin(string3));
                ILeaf iLeaf = classDiagram.getOrCreateLeaf(code, leafType, null);
                LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS);
                if (leafType == LeafType.INTERFACE && iEntity.getLeafType() != LeafType.INTERFACE) {
                    linkType = linkType.getDashed();
                }
                Link link = new Link(iLeaf, iEntity, linkType, Display.NULL, 2, null, null, classDiagram.getLabeldistance(), classDiagram.getLabelangle());
                classDiagram.addLink(link);
            }
        }
    }

    private IEntity executeArg0(ClassDiagram classDiagram, RegexResult regexResult) {
        Object object;
        Object object2;
        String string;
        ILeaf iLeaf;
        LeafType leafType = LeafType.getLeafType(StringUtils.goUpperCase(regexResult.get("TYPE", 0)));
        String string2 = regexResult.get("VISIBILITY", 0);
        VisibilityModifier visibilityModifier = null;
        if (string2 != null) {
            visibilityModifier = VisibilityModifier.getVisibilityModifier(string2 + "FOO", false);
        }
        Code code = Code.of(regexResult.getLazzy("CODE", 0)).eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
        String string3 = regexResult.getLazzy("DISPLAY", 0);
        String string4 = regexResult.getLazzy("DISPLAY", 1);
        String string5 = string4 != null ? string4 : regexResult.get("GENERIC", 0);
        String string6 = regexResult.get("STEREO", 0);
        if (classDiagram.leafExist(code)) {
            iLeaf = classDiagram.getOrCreateLeaf(code, null, null);
            if (!iLeaf.muteToType(leafType, null)) {
                return null;
            }
        } else {
            iLeaf = classDiagram.createLeaf(code, Display.getWithNewlines(string3), leafType, null);
        }
        iLeaf.setVisibilityModifier(visibilityModifier);
        if (string6 != null) {
            iLeaf.setStereotype(new Stereotype(string6, classDiagram.getSkinParam().getCircledCharacterRadius(), classDiagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), classDiagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object2 = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            object = ((UrlBuilder)object2).getUrl(string);
            iLeaf.addUrl((Url)object);
        }
        object2 = CommandCreateClassMultilines.color().getColor(regexResult, classDiagram.getSkinParam().getIHtmlColorSet());
        object = classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LINECOLOR", 1));
        if (object != null) {
            object2 = ((Colors)object2).add(ColorType.LINE, (HtmlColor)object);
        }
        if (regexResult.get("LINECOLOR", 0) != null) {
            object2 = ((Colors)object2).addLegacyStroke(regexResult.get("LINECOLOR", 0));
        }
        iLeaf.setColors((Colors)object2);
        if (string5 != null) {
            iLeaf.setGeneric(string5);
        }
        return iLeaf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

