/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateElementFull2
extends SingleLineCommand2<ClassDiagram> {
    private final Mode mode;

    public CommandCreateElementFull2(Mode mode) {
        super(CommandCreateElementFull2.getRegexConcat(mode));
        this.mode = mode;
    }

    private static RegexConcat getRegexConcat(Mode mode) {
        String string = "(?:(state|artifact|actor|folder|card|file|package|rectangle|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle)[%s]+)";
        if (mode == Mode.WITH_MIX_PREFIX) {
            string = "mix_" + string;
        }
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("SYMBOL", string), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[%g][^%g]+[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])"), new RegexLeaf("STEREOTYPE2", "(?:[%s]+(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*as[%s]+"), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])"))), new RegexLeaf("STEREOTYPE", "(?:[%s]*(\\<\\<.+\\>\\>))?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    @Override
    protected final boolean isForbidden(CharSequence charSequence) {
        return charSequence.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        String string;
        USymbol uSymbol;
        LeafType leafType;
        String string2;
        if (this.mode == Mode.NORMAL_KEYWORD && !classDiagram.isAllowMixing()) {
            return CommandExecutionResult.error("Use 'allow_mixing' if you want to mix classes and other UML elements.");
        }
        String string3 = regexResult.getLazzy("CODE", 0);
        String string4 = regexResult.getLazzy("DISPLAY", 0);
        char c = this.getCharEncoding(string3);
        char c2 = this.getCharEncoding(string4);
        if (string3.startsWith("()")) {
            string2 = "interface";
            string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(string3.substring(2)));
        } else {
            string2 = c == '(' || c2 == '(' ? "usecase" : (c == ':' || c2 == ':' ? "actor" : (c == '[' || c2 == '[' ? "component" : regexResult.get("SYMBOL", 0)));
        }
        if (string2 == null) {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.ACTOR;
        } else if (string2.equalsIgnoreCase("usecase")) {
            leafType = LeafType.USECASE;
            uSymbol = null;
        } else if (string2.equalsIgnoreCase("state")) {
            leafType = LeafType.STATE;
            uSymbol = null;
        } else {
            leafType = LeafType.DESCRIPTION;
            uSymbol = USymbol.getFromString(string2, classDiagram.getSkinParam().useUml2ForComponent());
            if (uSymbol == null) {
                throw new IllegalStateException();
            }
        }
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3));
        String string5 = string4;
        if (string5 == null) {
            string5 = code.getFullName();
        }
        string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5);
        String string6 = regexResult.getLazzy("STEREOTYPE", 0);
        ILeaf iLeaf = classDiagram.getOrCreateLeaf(code, leafType, uSymbol);
        iLeaf.setDisplay(Display.getWithNewlines(string5));
        iLeaf.setUSymbol(uSymbol);
        if (string6 != null) {
            iLeaf.setStereotype(new Stereotype(string6, classDiagram.getSkinParam().getCircledCharacterRadius(), classDiagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), classDiagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(string);
            iLeaf.addUrl(url);
        }
        iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }

    private char getCharEncoding(String string) {
        return string != null && string.length() > 2 ? string.charAt(0) : (char)'\u0000';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        NORMAL_KEYWORD,
        WITH_MIX_PREFIX;

    }
}

