/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandHideShowSpecificClass
extends SingleLineCommand2<CucaDiagram> {
    public CommandHideShowSpecificClass() {
        super(CommandHideShowSpecificClass.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("[%s]+"), new RegexLeaf("CODE", "([^%s{}%g<>]+)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(CucaDiagram cucaDiagram, RegexResult regexResult) {
        String string = regexResult.get("CODE", 0);
        if (string.equals("class")) {
            cucaDiagram.hideOrShow(LeafType.CLASS, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else if (string.equals("interface")) {
            cucaDiagram.hideOrShow(LeafType.INTERFACE, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else {
            Code code = Code.of(string);
            IEntity iEntity = cucaDiagram.getEntityFactory().getLeafs().get(code);
            if (iEntity == null) {
                iEntity = cucaDiagram.getEntityFactory().getGroups().get(code);
            }
            if (iEntity == null) {
                return CommandExecutionResult.error("Class/Package does not exist : " + code.getFullName());
            }
            cucaDiagram.hideOrShow(iEntity, regexResult.get("COMMAND", 0).equalsIgnoreCase("show"));
        }
        return CommandExecutionResult.ok();
    }
}

