/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLinkClass
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    private static final String SINGLE = "[.\\\\]{0,2}[\\p{L}0-9_]+(?:[.\\\\]{1,2}[\\p{L}0-9_]+)*";
    private static final String COUPLE = "\\([%s]*([.\\\\]{0,2}[\\p{L}0-9_]+(?:[.\\\\]{1,2}[\\p{L}0-9_]+)*)[%s]*,[%s]*([.\\\\]{0,2}[\\p{L}0-9_]+(?:[.\\\\]{1,2}[\\p{L}0-9_]+)*)[%s]*\\)";

    public CommandLinkClass(UmlDiagramType umlDiagramType) {
        super(CommandLinkClass.getRegexConcat(umlDiagramType));
    }

    private static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return new RegexConcat(new RegexLeaf("HEADER", "^(?:@([\\d.]+)[%s]+)?"), new RegexOr(new RegexLeaf("ENT1", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE1", COUPLE)), new RegexLeaf("[%s]*"), new RegexLeaf("FIRST_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexConcat(new RegexLeaf("ARROW_HEAD1", "([%s]+[ox]|[)#\\[<*+^}]|[<\\[]\\||\\}o|\\}\\||\\|o|\\|\\|)?"), new RegexLeaf("ARROW_BODY1", "([-=.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("INSIDE", "(?:(0|\\(0\\)|\\(0|0\\))(?=[-=.~]))?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-=.]*)"), new RegexLeaf("ARROW_HEAD2", "([ox][%s]+|[(#\\]>*+^\\{]|\\|[>\\]]|o\\{|\\|\\{|o\\||\\|\\|)?")), new RegexLeaf("[%s]*"), new RegexLeaf("SECOND_LABEL", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("ENT2", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE2", COUPLE)), new RegexLeaf("[%s]*"), CommandLinkClass.color().getRegex(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL_LINK", "(?::[%s]*(.+))?"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private static String getClassIdentifier() {
        return "(" + CommandLinkClass.getSeparator() + "?[\\p{L}0-9_$]+(?:" + CommandLinkClass.getSeparator() + "[\\p{L}0-9_$]+)*|[%g][^%g]+[%g])";
    }

    public static String getSeparator() {
        return "(?:\\.|::|\\\\|\\\\\\\\)";
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Code code = Code.of(regexResult.get("ENT1", 0));
        Code code2 = Code.of(regexResult.get("ENT2", 0));
        if (code == null) {
            return this.executeArgSpecial1(abstractClassOrObjectDiagram, regexResult);
        }
        if (code2 == null) {
            return this.executeArgSpecial2(abstractClassOrObjectDiagram, regexResult);
        }
        code = code.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        code2 = code2.eventuallyRemoveStartingAndEndingDoubleQuote("\"");
        if (this.isGroupButNotTheCurrentGroup(abstractClassOrObjectDiagram, code) && this.isGroupButNotTheCurrentGroup(abstractClassOrObjectDiagram, code2)) {
            return this.executePackageLink(abstractClassOrObjectDiagram, regexResult);
        }
        String string = null;
        String string2 = null;
        if (this.removeMemberPart(abstractClassOrObjectDiagram, code) != null) {
            string = code.getPortMember();
            code = this.removeMemberPart(abstractClassOrObjectDiagram, code);
        }
        if (this.removeMemberPart(abstractClassOrObjectDiagram, code2) != null) {
            string2 = code2.getPortMember();
            code2 = this.removeMemberPart(abstractClassOrObjectDiagram, code2);
        }
        IEntity iEntity = this.isGroupButNotTheCurrentGroup(abstractClassOrObjectDiagram, code) ? abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 0), "\""))) : abstractClassOrObjectDiagram.getOrCreateLeaf(code, null, null);
        IEntity iEntity2 = this.isGroupButNotTheCurrentGroup(abstractClassOrObjectDiagram, code2) ? abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 0), "\""))) : abstractClassOrObjectDiagram.getOrCreateLeaf(code2, null, null);
        Colors colors = CommandLinkClass.color().getColor(regexResult, abstractClassOrObjectDiagram.getSkinParam().getIHtmlColorSet());
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(regexResult);
        String string3 = regexResult.get("FIRST_LABEL", 0);
        String string4 = regexResult.get("SECOND_LABEL", 0);
        String string5 = null;
        if (regexResult.get("LABEL_LINK", 0) != null) {
            string5 = regexResult.get("LABEL_LINK", 0);
            if (string3 == null && string4 == null) {
                object4 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)[%g]([^%g]+)[%g]$");
                object3 = ((Pattern2)object4).matcher(string5);
                if (((Matcher2)object3).matches()) {
                    string3 = ((Matcher2)object3).group(1);
                    string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(((Matcher2)object3).group(2)), "\""));
                    string4 = ((Matcher2)object3).group(3);
                } else {
                    object2 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)$");
                    object = ((Pattern2)object2).matcher(string5);
                    if (((Matcher2)object).matches()) {
                        string3 = ((Matcher2)object).group(1);
                        string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(((Matcher2)object).group(2)), "\""));
                        string4 = null;
                    } else {
                        Pattern2 pattern2 = MyPattern.cmpile("^([^%g]+)[%g]([^%g]+)[%g]$");
                        Matcher2 matcher2 = pattern2.matcher(string5);
                        if (matcher2.matches()) {
                            string3 = null;
                            string5 = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(matcher2.group(1)), "\""));
                            string4 = matcher2.group(2);
                        }
                    }
                }
            }
            string5 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string5, "\"");
        }
        object4 = LinkArrow.NONE;
        if ("<".equals(string5)) {
            object4 = LinkArrow.BACKWARD;
            string5 = null;
        } else if (">".equals(string5)) {
            object4 = LinkArrow.DIRECT_NORMAL;
            string5 = null;
        } else if (string5 != null && string5.startsWith("< ")) {
            object4 = LinkArrow.BACKWARD;
            string5 = StringUtils.trin(string5.substring(2));
        } else if (string5 != null && string5.startsWith("> ")) {
            object4 = LinkArrow.DIRECT_NORMAL;
            string5 = StringUtils.trin(string5.substring(2));
        } else if (string5 != null && string5.endsWith(" >")) {
            object4 = LinkArrow.DIRECT_NORMAL;
            string5 = StringUtils.trin(string5.substring(0, string5.length() - 2));
        } else if (string5 != null && string5.endsWith(" <")) {
            object4 = LinkArrow.BACKWARD;
            string5 = StringUtils.trin(string5.substring(0, string5.length() - 2));
        }
        object3 = new Link(iEntity, iEntity2, linkType, Display.getWithNewlines(string5), n, string3, string4, abstractClassOrObjectDiagram.getLabeldistance(), abstractClassOrObjectDiagram.getLabelangle());
        if (regexResult.get("URL", 0) != null) {
            object2 = new UrlBuilder(abstractClassOrObjectDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            object = ((UrlBuilder)object2).getUrl(regexResult.get("URL", 0));
            ((Link)object3).setUrl((Url)object);
        }
        ((Link)object3).setPortMembers(string, string2);
        if (direction == Direction.LEFT || direction == Direction.UP) {
            object3 = ((Link)object3).getInv();
        }
        ((Link)object3).setLinkArrow((LinkArrow)((Object)object4));
        colors = CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), (Link)object3, colors);
        ((Link)object3).setColors(colors);
        this.addLink(abstractClassOrObjectDiagram, (Link)object3, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private boolean isGroupButNotTheCurrentGroup(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, Code code) {
        if (abstractClassOrObjectDiagram.getCurrentGroup().getCode().equals(code)) {
            return false;
        }
        return abstractClassOrObjectDiagram.isGroup(code);
    }

    private Code removeMemberPart(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, Code code) {
        if (abstractClassOrObjectDiagram.leafExist(code)) {
            return null;
        }
        Code code2 = code.removeMemberPart();
        if (code2 == null) {
            return null;
        }
        if (!abstractClassOrObjectDiagram.leafExist(code2)) {
            return null;
        }
        return code2;
    }

    private void addLink(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, Link link, String string) {
        abstractClassOrObjectDiagram.addLink(link);
        if (string != null) {
            link.setWeight(Double.parseDouble(string));
        }
    }

    private CommandExecutionResult executePackageLink(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        IGroup iGroup = abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 0), "\"")));
        IGroup iGroup2 = abstractClassOrObjectDiagram.getGroup(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 0), "\"")));
        LinkType linkType = this.getLinkType(regexResult);
        Direction direction = this.getDirection(regexResult);
        int n = direction == Direction.LEFT || direction == Direction.RIGHT ? 1 : this.getQueueLength(regexResult);
        Colors colors = CommandLinkClass.color().getColor(regexResult, abstractClassOrObjectDiagram.getSkinParam().getIHtmlColorSet());
        Display display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0));
        String string = regexResult.get("FIRST_LABEL", 0);
        String string2 = regexResult.get("SECOND_LABEL", 0);
        Link link = new Link(iGroup, iGroup2, linkType, display, n, string, string2, abstractClassOrObjectDiagram.getLabeldistance(), abstractClassOrObjectDiagram.getLabelangle());
        abstractClassOrObjectDiagram.resetPragmaLabel();
        colors = CommandLinkClass.applyStyle(regexResult.getLazzy("ARROW_STYLE", 0), link, colors);
        link.setColors(colors);
        this.addLink(abstractClassOrObjectDiagram, link, regexResult.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Display display;
        LinkType linkType;
        Code code = Code.of(regexResult.get("COUPLE1", 0));
        Code code2 = Code.of(regexResult.get("COUPLE1", 1));
        if (!abstractClassOrObjectDiagram.leafExist(code)) {
            return CommandExecutionResult.error("No class " + code);
        }
        if (!abstractClassOrObjectDiagram.leafExist(code2)) {
            return CommandExecutionResult.error("No class " + code2);
        }
        Code code3 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT2", 0), "\""));
        IEntity iEntity = abstractClassOrObjectDiagram.getOrCreateLeaf(code3, null, null);
        boolean bl = abstractClassOrObjectDiagram.associationClass(1, code, code2, iEntity, linkType = this.getLinkType(regexResult), display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0)));
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(AbstractClassOrObjectDiagram abstractClassOrObjectDiagram, RegexResult regexResult) {
        Display display;
        LinkType linkType;
        Code code = Code.of(regexResult.get("COUPLE2", 0));
        Code code2 = Code.of(regexResult.get("COUPLE2", 1));
        if (!abstractClassOrObjectDiagram.leafExist(code)) {
            return CommandExecutionResult.error("No class " + code);
        }
        if (!abstractClassOrObjectDiagram.leafExist(code2)) {
            return CommandExecutionResult.error("No class " + code2);
        }
        Code code3 = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("ENT1", 0), "\""));
        IEntity iEntity = abstractClassOrObjectDiagram.getOrCreateLeaf(code3, null, null);
        boolean bl = abstractClassOrObjectDiagram.associationClass(2, code, code2, iEntity, linkType = this.getLinkType(regexResult), display = Display.getWithNewlines(regexResult.get("LABEL_LINK", 0)));
        if (!bl) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private LinkDecor getDecors1(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(string = StringUtils.trin(string))) {
            return LinkDecor.EXTENDS;
        }
        if ("}".equals(string)) {
            return LinkDecor.CROWFOOT;
        }
        if ("}o".equals(string)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("}|".equals(string)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("|o".equals(string)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(string)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("<".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(string)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(string)) {
            return LinkDecor.SQUARE;
        }
        if (")".equals(string)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String string) {
        if (string == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(string = StringUtils.trin(string))) {
            return LinkDecor.EXTENDS;
        }
        if (">".equals(string)) {
            return LinkDecor.ARROW;
        }
        if ("{".equals(string)) {
            return LinkDecor.CROWFOOT;
        }
        if ("o{".equals(string)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("|{".equals(string)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("o|".equals(string)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(string)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("^".equals(string)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(string)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(string)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(string)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(string)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(string)) {
            return LinkDecor.SQUARE;
        }
        if ("(".equals(string)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(RegexResult regexResult) {
        String string;
        LinkDecor linkDecor = this.getDecors1(regexResult.get("ARROW_HEAD1", 0));
        LinkDecor linkDecor2 = this.getDecors2(regexResult.get("ARROW_HEAD2", 0));
        LinkType linkType = new LinkType(linkDecor2, linkDecor);
        if (regexResult.get("ARROW_BODY1", 0).contains(".") || regexResult.get("ARROW_BODY2", 0).contains(".")) {
            linkType = linkType.getDashed();
        }
        if ("0".equals(string = regexResult.get("INSIDE", 0))) {
            linkType = linkType.withMiddleCircle();
        } else if ("0)".equals(string)) {
            linkType = linkType.withMiddleCircleCircled1();
        } else if ("(0".equals(string)) {
            linkType = linkType.withMiddleCircleCircled2();
        } else if ("(0)".equals(string)) {
            linkType = linkType.withMiddleCircleCircled();
        }
        return linkType;
    }

    private int getQueueLength(RegexResult regexResult) {
        String string = this.getFullArrow(regexResult);
        string = string.replaceAll("[^-.=]", "");
        return string.length();
    }

    private Direction getDirection(RegexResult regexResult) {
        LinkDecor linkDecor = this.getDecors1(regexResult.get("ARROW_HEAD1", 0));
        LinkDecor linkDecor2 = this.getDecors2(regexResult.get("ARROW_HEAD2", 0));
        String string = this.getFullArrow(regexResult);
        if ((string = string.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            string = string.substring(1);
        }
        if (string.endsWith("o")) {
            string = string.substring(0, string.length() - 1);
        }
        Direction direction = StringUtils.getQueueDirection(string);
        if (this.isInversed(linkDecor, linkDecor2) && string.matches(".*\\w.*")) {
            direction = direction.getInv();
        }
        return direction;
    }

    private String getFullArrow(RegexResult regexResult) {
        return CommandLinkClass.notNull(regexResult.get("ARROW_HEAD1", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_BODY1", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_DIRECTION", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_BODY2", 0)) + CommandLinkClass.notNull(regexResult.get("ARROW_HEAD2", 0));
    }

    public static String notNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    @Deprecated
    public static Colors applyStyle(String string, Link link) {
        return CommandLinkClass.applyStyle(string, link, null);
    }

    public static Colors applyStyle(String string, Link link, Colors colors) {
        if (string == null) {
            return colors;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("dashed")) {
                link.goDashed();
                continue;
            }
            if (string2.equalsIgnoreCase("bold")) {
                link.goBold();
                continue;
            }
            if (string2.equalsIgnoreCase("dotted")) {
                link.goDotted();
                continue;
            }
            if (string2.equalsIgnoreCase("hidden")) {
                link.goHidden();
                continue;
            }
            if (string2.equalsIgnoreCase("plain")) continue;
            if (string2.equalsIgnoreCase("norank")) {
                link.goNorank();
                continue;
            }
            link.setSpecificColor(string2);
            if (colors == null) continue;
            colors = colors.add(ColorType.LINE, HtmlColorSet.getInstance().getColorIfValid(string2));
        }
        return colors;
    }

    private boolean isInversed(LinkDecor linkDecor, LinkDecor linkDecor2) {
        if (linkDecor == LinkDecor.ARROW && linkDecor2 != LinkDecor.ARROW) {
            return true;
        }
        if (linkDecor2 == LinkDecor.AGREGATION) {
            return true;
        }
        if (linkDecor2 == LinkDecor.COMPOSITION) {
            return true;
        }
        return linkDecor2 == LinkDecor.PLUS;
    }
}

