/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.IOException;
import java.io.StringReader;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.StringCompressor;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;

public class ArobaseStringCompressor
implements StringCompressor {
    private static final Pattern2 p = MyPattern.cmpile("(?s)(?i)^[%s]*(@startuml[^\\n\\r]*)?[%s]*(.*?)[%s]*(@enduml)?[%s]*$");

    public String compress(String string) throws IOException {
        UncommentReadLine uncommentReadLine = new UncommentReadLine(new ReadLineReader(new StringReader(string), "COMPRESS"));
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        CharSequence2 charSequence2 = null;
        boolean bl = false;
        while ((charSequence2 = uncommentReadLine.readLine()) != null) {
            this.append(stringBuilder2, charSequence2);
            if (charSequence2.toString2().startsWith("@startuml")) {
                bl = true;
                continue;
            }
            if (charSequence2.toString2().startsWith("@enduml")) {
                return stringBuilder.toString();
            }
            if (!bl) continue;
            this.append(stringBuilder, charSequence2);
        }
        if (!bl) {
            return this.compressOld(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    private void append(StringBuilder stringBuilder, CharSequence2 charSequence2) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append('\n');
        }
        stringBuilder.append(charSequence2.toString2());
    }

    private String compressOld(String string) throws IOException {
        Matcher2 matcher2 = p.matcher(string);
        if (matcher2.find()) {
            return this.clean(matcher2.group(2));
        }
        return "";
    }

    public String decompress(String string) throws IOException {
        String string2 = this.clean(string);
        if (string2.startsWith("@start")) {
            return string2;
        }
        string2 = "@startuml\n" + string2;
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        string2 = string2 + "@enduml";
        return string2;
    }

    private String clean(String string) {
        string = StringUtils.trin(string);
        string = this.clean1(string);
        string = string.replaceAll("@enduml[^\\n\\r]*", "");
        string = string.replaceAll("@startuml[^\\n\\r]*", "");
        string = StringUtils.trin(string);
        return string;
    }

    private String clean1(String string) {
        Matcher2 matcher2 = p.matcher(string);
        if (matcher2.matches()) {
            return matcher2.group(2);
        }
        return string;
    }
}

