/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilines<S extends Diagram>
implements Command<S> {
    private final Pattern2 starting;

    public CommandMultilines(String string) {
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.starting = MyPattern.cmpile(string);
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.pattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(BlocLines blocLines) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher2 matcher2 = this.starting.matcher(StringUtils.trin(blocLines.getFirst499()));
        if (!matcher2.matches()) {
            return CommandControl.NOT_OK;
        }
        if (blocLines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        matcher2 = MyPattern.cmpile(this.getPatternEnd()).matcher(StringUtils.trin(blocLines.getLast499()));
        if (!matcher2.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected final Pattern2 getStartingPattern() {
        return this.starting;
    }
}

