/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilinesBracket;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSkinParamMultilines
extends CommandMultilinesBracket<UmlDiagram> {
    private static final Pattern2 p1 = MyPattern.cmpile("^([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*)[%s]+(?:(\\{)|(.*))$|^\\}?$");

    public CommandSkinParamMultilines() {
        super("(?i)^skinparam[%s]*(?:[%s]+([\\w.]*(?:\\<\\<.*\\>\\>)?[\\w.]*))?[%s]*\\{$");
    }

    @Override
    protected boolean isLineConsistent(String string, int n) {
        if (this.hasStartingQuote(string = StringUtils.trin(string))) {
            return true;
        }
        return p1.matcher(string).matches();
    }

    private boolean hasStartingQuote(CharSequence charSequence) {
        return MyPattern.mtches(charSequence, "(?i)^[%s]*([%q].*||/[%q].*[%q]/[%s]*)$");
    }

    @Override
    public CommandExecutionResult execute(UmlDiagram umlDiagram, BlocLines blocLines) {
        Context context = new Context();
        Matcher2 matcher2 = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        if (matcher2.group(1) != null) {
            context.push(matcher2.group(1));
        }
        blocLines = blocLines.subExtract(1, 1);
        blocLines = blocLines.removeComments();
        blocLines = blocLines.trim(true);
        for (CharSequence charSequence : blocLines) {
            assert (charSequence.length() > 0);
            if (charSequence.toString().equals("}")) {
                context.pop();
                continue;
            }
            Matcher2 matcher22 = p1.matcher(charSequence);
            if (!matcher22.find()) {
                throw new IllegalStateException();
            }
            if (matcher22.group(2) != null) {
                context.push(matcher22.group(1));
                continue;
            }
            if (matcher22.group(3) != null) {
                String string = context.getFullParam() + matcher22.group(1);
                umlDiagram.setParam(string, matcher22.group(3));
                continue;
            }
            throw new IllegalStateException("." + charSequence.toString() + ".");
        }
        return CommandExecutionResult.ok();
    }

    static class Context {
        private List<String> strings = new ArrayList<String>();

        Context() {
        }

        public void push(String string) {
            this.strings.add(string);
        }

        public void pop() {
            this.strings.remove(this.strings.size() - 1);
        }

        public String getFullParam() {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.strings) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
    }
}

