/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteImage;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandSpriteFile
extends SingleLineCommand2<UmlDiagram> {
    public CommandSpriteFile() {
        super(CommandSpriteFile.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("sprite[%s]+\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)[%s]*"), new RegexLeaf("[%s]+"), new RegexLeaf("FILE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(UmlDiagram umlDiagram, RegexResult regexResult) {
        Sprite sprite;
        String string = regexResult.get("FILE", 0);
        try {
            if (string.startsWith("jar:")) {
                String string2 = string.substring(4) + ".png";
                InputStream inputStream = SpriteImage.getInternalSprite(string2);
                if (inputStream == null) {
                    return CommandExecutionResult.error("No such internal sprite: " + string2);
                }
                sprite = new SpriteImage(ImageIO.read(inputStream));
            } else if (string.contains("~")) {
                int n = string.lastIndexOf("~");
                File file = FileSystem.getInstance().getFile(string.substring(0, n));
                if (!file.exists()) {
                    return CommandExecutionResult.error("File does not exist: " + string);
                }
                String string3 = string.substring(n + 1);
                sprite = this.getImageFromZip(file, string3);
                if (sprite == null) {
                    return CommandExecutionResult.error("No image " + string3 + " in " + file.getAbsolutePath());
                }
            } else {
                File file = FileSystem.getInstance().getFile(string);
                if (!file.exists()) {
                    return CommandExecutionResult.error("File does not exist: " + string);
                }
                sprite = this.isSvg(file.getName()) ? new SpriteSvg(file) : new SpriteImage(ImageIO.read(file));
            }
        }
        catch (IOException iOException) {
            Log.error("Error reading " + string + " " + iOException);
            return CommandExecutionResult.error("Cannot read: " + string);
        }
        umlDiagram.addSprite(regexResult.get("NAME", 0), sprite);
        return CommandExecutionResult.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sprite getImageFromZip(File file, String string) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String string2 = zipEntry.getName();
                if (!zipEntry.isDirectory() && string2.equals(string)) {
                    if (this.isSvg(string)) {
                        SpriteSvg spriteSvg = new SpriteSvg(FileUtils.readSvg(zipInputStream));
                        return spriteSvg;
                    }
                    SpriteImage spriteImage = new SpriteImage(ImageIO.read(zipInputStream));
                    return spriteImage;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.closeEntry();
                zipInputStream.close();
            }
        }
        return null;
    }

    private boolean isSvg(String string) {
        return string.toLowerCase().endsWith(".svg");
    }
}

