/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteGrayLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySpriteCommand
implements SingleMultiFactoryCommand<UmlDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("sprite[%s]+\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)[%s]*"), new RegexLeaf("DIM", "(?:\\[(\\d+)x(\\d+)/(\\d+)(z)?\\])?"), new RegexLeaf("[%s]*\\{"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("sprite[%s]+\\$?"), new RegexLeaf("NAME", "([\\p{L}0-9_]+)[%s]*"), new RegexLeaf("DIM", "(?:\\[(\\d+)x(\\d+)/(\\d+)(z)\\])?"), new RegexLeaf("[%s]+"), new RegexLeaf("DATA", "([-_A-Za-z0-9]+)"), new RegexLeaf("$"));
    }

    @Override
    public Command<UmlDiagram> createSingleLine() {
        return new SingleLineCommand2<UmlDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(UmlDiagram umlDiagram, RegexResult regexResult) {
                return FactorySpriteCommand.this.executeInternal(umlDiagram, regexResult, Arrays.asList(regexResult.get("DATA", 0)));
            }
        };
    }

    @Override
    public Command<UmlDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<UmlDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.REMOVE_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?sprite|\\}$";
            }

            @Override
            public CommandExecutionResult executeNow(UmlDiagram umlDiagram, BlocLines blocLines) {
                blocLines = blocLines.trim(true);
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                if ((blocLines = blocLines.removeEmptyColumns()).size() == 0) {
                    return CommandExecutionResult.error("No sprite defined.");
                }
                return FactorySpriteCommand.this.executeInternal(umlDiagram, regexResult, blocLines.getLines());
            }
        };
    }

    private CommandExecutionResult executeInternal(UmlDiagram umlDiagram, RegexResult regexResult, List<CharSequence> list) {
        try {
            Sprite sprite;
            if (regexResult.get("DIM", 0) == null) {
                sprite = SpriteGrayLevel.GRAY_16.buildSprite(-1, -1, list);
            } else {
                int n = Integer.parseInt(regexResult.get("DIM", 0));
                int n2 = Integer.parseInt(regexResult.get("DIM", 1));
                int n3 = Integer.parseInt(regexResult.get("DIM", 2));
                if (n3 != 4 && n3 != 8 && n3 != 16) {
                    return CommandExecutionResult.error("Only 4, 8 or 16 graylevel are allowed.");
                }
                SpriteGrayLevel spriteGrayLevel = SpriteGrayLevel.get(n3);
                sprite = regexResult.get("DIM", 3) == null ? spriteGrayLevel.buildSprite(n, n2, list) : spriteGrayLevel.buildSpriteZ(n, n2, this.concat(list));
            }
            umlDiagram.addSprite(regexResult.get("NAME", 0), sprite);
            return CommandExecutionResult.ok();
        }
        catch (IOException iOException) {
            return CommandExecutionResult.error("Cannot decode sprite.");
        }
    }

    private String concat(List<? extends CharSequence> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : list) {
            stringBuilder.append(StringUtils.trin(charSequence));
        }
        return stringBuilder.toString();
    }
}

