/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShowByGender;
import net.sourceforge.plantuml.classdiagram.command.CommandHideShowByVisibility;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandAffineTransform;
import net.sourceforge.plantuml.command.CommandAffineTransformMultiline;
import net.sourceforge.plantuml.command.CommandCaption;
import net.sourceforge.plantuml.command.CommandComment;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandDecoratorMultine;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandFooter;
import net.sourceforge.plantuml.command.CommandHeader;
import net.sourceforge.plantuml.command.CommandHideUnlinked;
import net.sourceforge.plantuml.command.CommandMinwidth;
import net.sourceforge.plantuml.command.CommandMultilinesComment;
import net.sourceforge.plantuml.command.CommandMultilinesFooter;
import net.sourceforge.plantuml.command.CommandMultilinesHeader;
import net.sourceforge.plantuml.command.CommandMultilinesLegend;
import net.sourceforge.plantuml.command.CommandMultilinesTitle;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.CommandPragma;
import net.sourceforge.plantuml.command.CommandRotate;
import net.sourceforge.plantuml.command.CommandScale;
import net.sourceforge.plantuml.command.CommandScaleMaxHeight;
import net.sourceforge.plantuml.command.CommandScaleMaxWidth;
import net.sourceforge.plantuml.command.CommandScaleMaxWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthAndHeight;
import net.sourceforge.plantuml.command.CommandScaleWidthOrHeight;
import net.sourceforge.plantuml.command.CommandSkinParam;
import net.sourceforge.plantuml.command.CommandSkinParamMultilines;
import net.sourceforge.plantuml.command.CommandSpriteFile;
import net.sourceforge.plantuml.command.CommandTitle;
import net.sourceforge.plantuml.command.FactorySpriteCommand;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.suggest.SuggestEngine;
import net.sourceforge.plantuml.suggest.SuggestEngineResult;
import net.sourceforge.plantuml.suggest.SuggestEngineStatus;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UmlDiagramFactory
extends PSystemAbstractFactory {
    private final List<Command> cmds = this.createCommands();

    protected UmlDiagramFactory() {
        this(DiagramType.UML);
    }

    protected UmlDiagramFactory(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public final Diagram createSystem(UmlSource umlSource) {
        IteratorCounter2 iteratorCounter2 = umlSource.iterator2();
        CharSequence2 charSequence2 = (CharSequence2)iteratorCounter2.next();
        if (!StartUtils.isArobaseStartDiagram(charSequence2)) {
            throw new UnsupportedOperationException();
        }
        if (umlSource.isEmpty()) {
            return this.buildEmptyError(umlSource, charSequence2.getLocation());
        }
        AbstractPSystem abstractPSystem = this.createEmptyDiagram();
        while (iteratorCounter2.hasNext()) {
            if (StartUtils.isArobaseEndDiagram(iteratorCounter2.peek())) {
                if (abstractPSystem == null) {
                    return null;
                }
                String string = abstractPSystem.checkFinalError();
                if (string != null) {
                    return this.buildExecutionError(umlSource, string, iteratorCounter2.peek().getLocation());
                }
                if (umlSource.getTotalLineCount() == 2) {
                    return this.buildEmptyError(umlSource, iteratorCounter2.peek().getLocation());
                }
                abstractPSystem.makeDiagramReady();
                if (!abstractPSystem.isOk()) {
                    return null;
                }
                abstractPSystem.setSource(umlSource);
                return abstractPSystem;
            }
            if (!((abstractPSystem = this.executeOneLine(abstractPSystem, umlSource, iteratorCounter2)) instanceof PSystemError)) continue;
            return abstractPSystem;
        }
        abstractPSystem.setSource(umlSource);
        return abstractPSystem;
    }

    private AbstractPSystem executeOneLine(AbstractPSystem abstractPSystem, UmlSource umlSource, IteratorCounter2 iteratorCounter2) {
        CommandControl commandControl = this.isValid2(iteratorCounter2);
        if (commandControl == CommandControl.NOT_OK) {
            SuggestEngine suggestEngine;
            SuggestEngineResult suggestEngineResult;
            ErrorUml errorUml = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", iteratorCounter2.peek().getLocation());
            if (OptionFlags.getInstance().isUseSuggestEngine() && (suggestEngineResult = (suggestEngine = new SuggestEngine(umlSource, this)).tryToSuggest(abstractPSystem)).getStatus() == SuggestEngineStatus.ONE_SUGGESTION) {
                errorUml.setSuggest(suggestEngineResult);
            }
            abstractPSystem = new PSystemError(umlSource, errorUml, null);
        } else if (commandControl == CommandControl.OK_PARTIAL) {
            IteratorCounter2 iteratorCounter22 = iteratorCounter2.cloneMe();
            CommandExecutionResult commandExecutionResult = this.manageMultiline2(iteratorCounter2, abstractPSystem);
            if (!commandExecutionResult.isOk()) {
                ErrorUml errorUml = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, commandExecutionResult.getError(), ((CharSequence2)iteratorCounter22.next()).getLocation());
                abstractPSystem = new PSystemError(umlSource, errorUml, null);
            }
        } else if (commandControl == CommandControl.OK) {
            CharSequence charSequence = (CharSequence)iteratorCounter2.next();
            BlocLines blocLines = BlocLines.single(charSequence);
            Command command = this.getFirstCommandOkForLines(blocLines);
            CommandExecutionResult commandExecutionResult = abstractPSystem.executeCommand(command, blocLines);
            if (!commandExecutionResult.isOk()) {
                ErrorUml errorUml = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, commandExecutionResult.getError(), ((CharSequence2)charSequence).getLocation());
                abstractPSystem = new PSystemError(umlSource, errorUml, commandExecutionResult.getDebugLines());
            }
            if (commandExecutionResult.getNewDiagram() != null) {
                abstractPSystem = commandExecutionResult.getNewDiagram();
            }
        } else assert (false);
        return abstractPSystem;
    }

    public CommandControl isValid2(IteratorCounter2 iteratorCounter2) {
        BlocLines blocLines = BlocLines.single(iteratorCounter2.peek());
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(blocLines);
            if (commandControl == CommandControl.OK) {
                return commandControl;
            }
            if (commandControl != CommandControl.OK_PARTIAL || this.isMultilineCommandOk(iteratorCounter2.cloneMe(), command) == null) continue;
            return commandControl;
        }
        return CommandControl.NOT_OK;
    }

    public CommandControl goForwardMultiline(IteratorCounter2 iteratorCounter2) {
        BlocLines blocLines = BlocLines.single(iteratorCounter2.peek());
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(blocLines);
            if (commandControl == CommandControl.OK) {
                throw new IllegalStateException();
            }
            if (commandControl != CommandControl.OK_PARTIAL || this.isMultilineCommandOk(iteratorCounter2, command) == null) continue;
            return commandControl;
        }
        return CommandControl.NOT_OK;
    }

    private CommandExecutionResult manageMultiline2(IteratorCounter2 iteratorCounter2, AbstractPSystem abstractPSystem) {
        for (Command command : this.cmds) {
            if (this.isMultilineCommandOk(iteratorCounter2.cloneMe(), command) == null) continue;
            BlocLines blocLines = this.isMultilineCommandOk(iteratorCounter2, command);
            if (abstractPSystem instanceof NewpagedDiagram) {
                NewpagedDiagram newpagedDiagram = (NewpagedDiagram)abstractPSystem;
                return command.execute(newpagedDiagram.getLastDiagram(), blocLines);
            }
            return command.execute(abstractPSystem, blocLines);
        }
        return CommandExecutionResult.ok();
    }

    private BlocLines isMultilineCommandOk(IteratorCounter2 iteratorCounter2, Command command) {
        BlocLines blocLines = new BlocLines();
        int n = 0;
        while (iteratorCounter2.hasNext()) {
            CommandControl commandControl = command.isValid(blocLines = this.addOneSingleLineManageEmbedded2(iteratorCounter2, blocLines));
            if (commandControl == CommandControl.NOT_OK) {
                return null;
            }
            if (commandControl == CommandControl.OK) {
                return blocLines;
            }
            if (!(command instanceof CommandDecoratorMultine) || ++n <= ((CommandDecoratorMultine)command).getNbMaxLines()) continue;
            return null;
        }
        return null;
    }

    private BlocLines addOneSingleLineManageEmbedded2(IteratorCounter2 iteratorCounter2, BlocLines blocLines) {
        CharSequence charSequence = (CharSequence)iteratorCounter2.next();
        blocLines = blocLines.add2(charSequence);
        if (StringUtils.trinNoTrace(charSequence).equals("{{")) {
            while (iteratorCounter2.hasNext()) {
                CharSequence charSequence2 = (CharSequence)iteratorCounter2.next();
                blocLines = blocLines.add2(charSequence2);
                if (!StringUtils.trinNoTrace(charSequence2).equals("}}")) continue;
                return blocLines;
            }
        }
        return blocLines;
    }

    public final CommandControl isValid(BlocLines blocLines) {
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(blocLines);
            if (commandControl == CommandControl.OK) {
                return commandControl;
            }
            if (commandControl != CommandControl.OK_PARTIAL) continue;
            return commandControl;
        }
        return CommandControl.NOT_OK;
    }

    private Command getFirstCommandOkForLines(BlocLines blocLines) {
        for (Command command : this.cmds) {
            CommandControl commandControl = command.isValid(blocLines);
            if (commandControl != CommandControl.OK) continue;
            return command;
        }
        throw new IllegalArgumentException();
    }

    protected abstract List<Command> createCommands();

    public abstract AbstractPSystem createEmptyDiagram();

    protected final void addCommonCommands(List<Command> list) {
        list.add(new CommandNope());
        list.add(new CommandComment());
        list.add(new CommandMultilinesComment());
        list.add(new CommandPragma());
        list.add(new CommandTitle());
        list.add(new CommandCaption());
        list.add(new CommandMultilinesTitle());
        list.add(new CommandMultilinesLegend());
        list.add(new CommandFooter());
        list.add(new CommandMultilinesFooter());
        list.add(new CommandHeader());
        list.add(new CommandMultilinesHeader());
        list.add(new CommandSkinParam());
        list.add(new CommandSkinParamMultilines());
        list.add(new CommandMinwidth());
        list.add(new CommandRotate());
        list.add(new CommandScale());
        list.add(new CommandScaleWidthAndHeight());
        list.add(new CommandScaleWidthOrHeight());
        list.add(new CommandScaleMaxWidth());
        list.add(new CommandScaleMaxHeight());
        list.add(new CommandScaleMaxWidthAndHeight());
        list.add(new CommandAffineTransform());
        list.add(new CommandAffineTransformMultiline());
        list.add(new CommandHideUnlinked());
        FactorySpriteCommand factorySpriteCommand = new FactorySpriteCommand();
        list.add(factorySpriteCommand.createMultiLine(false));
        list.add(factorySpriteCommand.createSingleLine());
        list.add(new CommandSpriteFile());
        list.add(new CommandHideShowByVisibility());
        list.add(new CommandHideShowByGender());
    }

    public final List<String> getDescription() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Command command : this.createCommands()) {
            arrayList.addAll(Arrays.asList(command.getDescription()));
        }
        return Collections.unmodifiableList(arrayList);
    }
}

