/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySequenceNoteOnArrowCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)"), new RegexLeaf("[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), ColorParser.exp1(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)"), new RegexLeaf("[%s]+"), new RegexLeaf("POSITION", "(right|left)[%s]*"), ColorParser.exp1(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(sequenceDiagram, regexResult, BlocLines.getWithNewlines(regexResult.get("NOTE", 0)));
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram sequenceDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(sequenceDiagram, regexResult, blocLines);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, RegexResult regexResult, BlocLines blocLines) {
        EventWithDeactivate eventWithDeactivate = sequenceDiagram.getLastEventWithDeactivate();
        if (eventWithDeactivate instanceof AbstractMessage || eventWithDeactivate instanceof GroupingLeaf) {
            Object object;
            NotePosition notePosition = NotePosition.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0)));
            Url url = null;
            if (regexResult.get("URL", 0) != null) {
                object = new UrlBuilder(sequenceDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                url = ((UrlBuilder)object).getUrl(regexResult.get("URL", 0));
            }
            object = NoteStyle.getNoteStyle(regexResult.get("STYLE", 0));
            if (eventWithDeactivate instanceof AbstractMessage) {
                ((AbstractMessage)eventWithDeactivate).setNote(blocLines.toDisplay(), notePosition, (NoteStyle)((Object)object), regexResult.get("COLOR", 0), url);
            } else {
                ((GroupingLeaf)eventWithDeactivate).setNote(blocLines.toDisplay(), notePosition, (NoteStyle)((Object)object), regexResult.get("COLOR", 0), url);
            }
        }
        return CommandExecutionResult.ok();
    }
}

