/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class CommandCreoleFontFamilyChange
implements Command {
    private final Pattern2 pattern;

    public static Command create() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*?)\\</font\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleFontFamilyChange("^(?i)(\\<font[\\s:]+([^>]+)/?\\>(.*)$)");
    }

    private CommandCreoleFontFamilyChange(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(1).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        String string2 = matcher2.group(2);
        FontConfiguration fontConfiguration2 = fontConfiguration.changeFamily(string2);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher2.group(3));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher2.group(1).length());
    }
}

