/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.BackSlash;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomTable;
import net.sourceforge.plantuml.creole.AtomWithMargin;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripeTable
implements Stripe {
    private FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTable table;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');

    public StripeTable(FontConfiguration fontConfiguration, ISkinSimple iSkinSimple, String string) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = iSkinSimple;
        this.table = new AtomTable(fontConfiguration.getColor());
        this.marged = new AtomWithMargin(this.table, 2.0, 2.0);
        this.analyzeAndAddInternal(string, Mode.HEADER);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    static Atom asAtom(List<StripeSimple> list, double d) {
        Sheet sheet = new Sheet(HorizontalAlignment.LEFT);
        for (StripeSimple stripeSimple : list) {
            sheet.add(stripeSimple);
        }
        return new SheetBlock1(sheet, LineBreakStrategy.NONE, d);
    }

    private HtmlColor getBackColor(String string) {
        if (CreoleParser.doesStartByColor(string)) {
            int n = string.indexOf(35);
            int n2 = string.indexOf(62);
            if (n2 == -1) {
                throw new IllegalStateException();
            }
            String string2 = string.substring(n, n2);
            return this.skinParam.getIHtmlColorSet().getColorIfValid(string2);
        }
        return null;
    }

    private String withouBackColor(String string) {
        int n = string.indexOf(62);
        if (n == -1) {
            throw new IllegalStateException();
        }
        return string.substring(n + 1);
    }

    private void analyzeAndAddInternal(String string, Mode mode) {
        HtmlColor htmlColor = this.getBackColor(string);
        if (htmlColor != null) {
            string = this.withouBackColor(string);
        }
        this.table.newLine(htmlColor);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            HtmlColor htmlColor2 = this.getBackColor(string2);
            if (htmlColor2 != null) {
                string2 = this.withouBackColor(string2);
            }
            if (mode == Mode.HEADER && string2.startsWith("=")) {
                string2 = string2.substring(1);
            }
            List<String> list = StripeTable.getWithNewlinesInternal(string2);
            ArrayList<StripeSimple> arrayList = new ArrayList<StripeSimple>();
            for (String string3 : list) {
                StripeSimple stripeSimple = new StripeSimple(this.getFontConfiguration(mode), this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
                if (string3.startsWith("<r>")) {
                    stripeSimple.setCellAlignment(HorizontalAlignment.RIGHT);
                    string3 = string3.substring("<r>".length());
                }
                stripeSimple.analyzeAndAdd(string3);
                arrayList.add(stripeSimple);
            }
            this.table.addCell(StripeTable.asAtom(arrayList, this.skinParam.getPadding()), htmlColor2);
        }
    }

    static List<String> getWithNewlinesInternal(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() - 1) {
                char c2 = string.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == '\\') {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append(c);
                stringBuilder.append(c2);
                continue;
            }
            if (c == BackSlash.hiddenNewLine()) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private FontConfiguration getFontConfiguration(Mode mode) {
        if (mode == Mode.NORMAL) {
            return this.fontConfiguration;
        }
        return this.fontConfiguration.bold();
    }

    public void analyzeAndAddNormal(String string) {
        this.analyzeAndAddInternal(string, Mode.NORMAL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        HEADER,
        NORMAL;

    }
}

