/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class MemberImpl
implements Member {
    private final String display;
    private final boolean staticModifier;
    private final boolean abstractModifier;
    private final Url url;
    private final boolean hasUrl;
    private final VisibilityModifier visibilityModifier;

    public MemberImpl(String string, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        string = string.replaceAll("(?i)\\{(method|field)\\}\\s*", "");
        if (bl2) {
            object2 = MyPattern.cmpile("^(.*?)(?:\\[(" + UrlBuilder.getRegexp() + ")\\])?$");
            object = ((Pattern2)object2).matcher(string);
            if (!((Matcher2)object).matches()) {
                throw new IllegalStateException();
            }
            string = ((Matcher2)object).group(1);
            String string2 = ((Matcher2)object).group(2);
            this.url = string2 == null ? null : new UrlBuilder(null, UrlBuilder.ModeUrl.STRICT).getUrl(string2);
        } else {
            this.url = null;
        }
        this.hasUrl = this.url != null;
        object2 = StringUtils.goLowerCase(string);
        if (bl2) {
            this.staticModifier = ((String)object2).contains("{static}") || ((String)object2).contains("{classifier}");
            this.abstractModifier = ((String)object2).contains("{abstract}");
            object = string.replaceAll("(?i)\\{(static|classifier|abstract)\\}\\s*", "").trim();
            if (((String)object).length() == 0) {
                object = " ";
            }
            if (VisibilityModifier.isVisibilityCharacter((CharSequence)object)) {
                this.visibilityModifier = VisibilityModifier.getVisibilityModifier((CharSequence)object, !bl);
                this.display = StringUtils.trin(StringUtils.manageGuillemet(((String)object).substring(1)));
            } else {
                this.display = StringUtils.manageGuillemet((String)object);
                this.visibilityModifier = null;
            }
        } else {
            this.staticModifier = false;
            this.visibilityModifier = null;
            this.abstractModifier = false;
            this.display = (string = StringUtils.trin(string)).length() == 0 ? " " : StringUtils.manageGuillemet(StringUtils.trin(string));
        }
    }

    public String getDisplay(boolean bl) {
        if (bl) {
            return this.getDisplayWithVisibilityChar();
        }
        return this.getDisplayWithoutVisibilityChar();
    }

    private String getDisplayWithoutVisibilityChar() {
        return this.display;
    }

    private String getDisplayWithVisibilityChar() {
        if (this.isPrivate()) {
            return "-" + this.display;
        }
        if (this.isPublic()) {
            return "+" + this.display;
        }
        if (this.isPackagePrivate()) {
            return "~" + this.display;
        }
        if (this.isProtected()) {
            return "#" + this.display;
        }
        if (this.isIEMandatory()) {
            return "*" + this.display;
        }
        return this.display;
    }

    public boolean equals(Object object) {
        MemberImpl memberImpl = (MemberImpl)object;
        return this.display.equals(memberImpl.display);
    }

    public int hashCode() {
        return this.display.hashCode();
    }

    public final boolean isStatic() {
        return this.staticModifier;
    }

    public final boolean isAbstract() {
        return this.abstractModifier;
    }

    private boolean isPrivate() {
        return this.visibilityModifier == VisibilityModifier.PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PRIVATE_METHOD;
    }

    private boolean isProtected() {
        return this.visibilityModifier == VisibilityModifier.PROTECTED_FIELD || this.visibilityModifier == VisibilityModifier.PROTECTED_METHOD;
    }

    private boolean isPublic() {
        return this.visibilityModifier == VisibilityModifier.PUBLIC_FIELD || this.visibilityModifier == VisibilityModifier.PUBLIC_METHOD;
    }

    private boolean isPackagePrivate() {
        return this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_FIELD || this.visibilityModifier == VisibilityModifier.PACKAGE_PRIVATE_METHOD;
    }

    private boolean isIEMandatory() {
        return this.visibilityModifier == VisibilityModifier.IE_MANDATORY;
    }

    public final VisibilityModifier getVisibilityModifier() {
        return this.visibilityModifier;
    }

    public final Url getUrl() {
        return this.url;
    }

    public boolean hasUrl() {
        return this.hasUrl;
    }

    public static boolean isMethod(String string) {
        if (string.contains("{method}")) {
            return true;
        }
        if (string.contains("{field}")) {
            return false;
        }
        return string.contains("(") || string.contains(")");
    }
}

