/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Hideable;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stereotype
implements CharSequence,
Hideable {
    private static final Pattern2 circleChar = MyPattern.cmpile("\\<\\<[%s]*\\(?(\\S)[%s]*,[%s]*(#[0-9a-fA-F]{6}|\\w+)[%s]*(?:[),](.*?))?\\>\\>");
    private static final Pattern2 circleSprite = MyPattern.cmpile("\\<\\<[%s]*\\(?\\$([-\\p{L}0-9_/]+)[%s]*(?:,[%s]*(#[0-9a-fA-F]{6}|\\w+))?[%s]*(?:[),](.*?))?\\>\\>");
    private final double radius;
    private final UFont circledFont;
    private final boolean automaticPackageStyle;
    private String label;
    private HtmlColor htmlColor;
    private char character;
    private String sprite;

    public Stereotype(String string, double d, UFont uFont, IHtmlColorSet iHtmlColorSet) {
        this(string, d, uFont, true, iHtmlColorSet);
    }

    public Stereotype(String string, double d, UFont uFont, boolean bl, IHtmlColorSet iHtmlColorSet) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!string.startsWith("<<") || !string.endsWith(">>")) {
            throw new IllegalArgumentException(string);
        }
        this.automaticPackageStyle = bl;
        this.radius = d;
        this.circledFont = uFont;
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = Stereotype.cutLabels(string, false);
        for (String string2 : list) {
            String string3;
            Matcher2 matcher2 = circleChar.matcher(string2);
            Matcher2 matcher22 = circleSprite.matcher(string2);
            if (matcher22.find()) {
                string2 = StringUtils.isNotEmpty(matcher22.group(3)) ? "<<" + matcher22.group(3) + ">>" : null;
                string3 = matcher22.group(2);
                HtmlColor htmlColor = iHtmlColorSet.getColorIfValid(string3);
                this.htmlColor = htmlColor == null ? HtmlColorUtils.BLACK : htmlColor;
                this.sprite = matcher22.group(1);
                this.character = '\u0000';
            } else if (matcher2.find()) {
                string2 = StringUtils.isNotEmpty(matcher2.group(3)) ? "<<" + matcher2.group(3) + ">>" : null;
                string3 = matcher2.group(2);
                this.htmlColor = iHtmlColorSet.getColorIfValid(string3);
                this.character = matcher2.group(1).charAt(0);
                this.sprite = null;
            }
            if (string2 == null) continue;
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() > 0) {
            this.label = stringBuilder.toString();
        }
    }

    public Stereotype(String string) {
        this(string, true);
    }

    public Stereotype(String string, boolean bl) {
        this.automaticPackageStyle = bl;
        this.label = string;
        this.htmlColor = null;
        this.character = '\u0000';
        this.radius = 0.0;
        this.circledFont = null;
        this.sprite = string.startsWith("<<$") && string.endsWith(">>") ? string.substring(3, string.length() - 2).trim() : null;
    }

    public HtmlColor getHtmlColor() {
        return this.htmlColor;
    }

    public char getCharacter() {
        return this.character;
    }

    public final String getSprite() {
        return this.sprite;
    }

    public boolean isWithOOSymbol() {
        return "<<O-O>>".equalsIgnoreCase(this.label);
    }

    public List<String> getMultipleLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.label != null) {
            Pattern pattern = Pattern.compile("\\<\\<\\s?((?:\\<&\\w+\\>|[^<>])+?)\\s?\\>\\>");
            Matcher matcher = pattern.matcher(this.label);
            while (matcher.find()) {
                arrayList.add(matcher.group(1));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public boolean isSpotted() {
        return this.character != '\u0000';
    }

    @Override
    public String toString() {
        if (this.label == null) {
            return "" + this.character;
        }
        if (this.character == '\u0000') {
            return this.label;
        }
        return this.character + " " + this.label;
    }

    @Override
    public char charAt(int n) {
        return this.toString().charAt(n);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    public double getRadius() {
        return this.radius;
    }

    public final UFont getCircledFont() {
        return this.circledFont;
    }

    public String getLabel(boolean bl) {
        assert (this.label == null || this.label.length() > 0);
        if (this.isWithOOSymbol()) {
            return null;
        }
        if (bl) {
            return StringUtils.manageGuillemet(this.label);
        }
        return this.label;
    }

    public List<String> getLabels(boolean bl) {
        String string = this.getLabel(false);
        if (string == null) {
            return null;
        }
        return Stereotype.cutLabels(string, bl);
    }

    private static List<String> cutLabels(String string, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern2 pattern2 = MyPattern.cmpile("\\<\\<.*?\\>\\>");
        Matcher2 matcher2 = pattern2.matcher(string);
        while (matcher2.find()) {
            if (bl) {
                arrayList.add(StringUtils.manageGuillemetStrict(matcher2.group()));
                continue;
            }
            arrayList.add(matcher2.group());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public PackageStyle getPackageStyle() {
        if (!this.automaticPackageStyle) {
            return null;
        }
        for (PackageStyle packageStyle : EnumSet.allOf(PackageStyle.class)) {
            if (!("<<" + (Object)((Object)packageStyle) + ">>").equalsIgnoreCase(this.label)) continue;
            return packageStyle;
        }
        return null;
    }

    @Override
    public boolean isHidden() {
        return "<<hidden>>".equalsIgnoreCase(this.label);
    }
}

