/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

public class GraphvizVersionFinder {
    private final File dotExe;
    public static final GraphvizVersion DEFAULT = new GraphvizVersion(){

        public boolean useShield() {
            return true;
        }

        public boolean useProtectionWhenThereALinkFromOrToGroup() {
            return true;
        }

        public boolean modeSafe() {
            return false;
        }

        public boolean isVizjs() {
            return false;
        }
    };

    public GraphvizVersionFinder(File file) {
        this.dotExe = file;
    }

    public GraphvizVersion getVersion() {
        String string = this.dotVersion();
        Pattern pattern = Pattern.compile("\\d\\.\\d\\d");
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.find();
        if (!bl) {
            return DEFAULT;
        }
        String string2 = matcher.group(0);
        final int n = Integer.parseInt(string2.replaceAll("\\.", ""));
        return new GraphvizVersion(){

            public boolean useShield() {
                return n <= 228;
            }

            public boolean useProtectionWhenThereALinkFromOrToGroup() {
                return n != 239 && n != 240;
            }

            public boolean modeSafe() {
                return false;
            }

            public boolean isVizjs() {
                return false;
            }
        };
    }

    public String dotVersion() {
        String[] stringArray = this.getCommandLine();
        ProcessRunner processRunner = new ProcessRunner(stringArray);
        ProcessState processState = processRunner.run(null, null);
        if (processState.differs(ProcessState.TERMINATED_OK())) {
            return "?";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty(processRunner.getOut())) {
            stringBuilder.append(processRunner.getOut());
        }
        if (StringUtils.isNotEmpty(processRunner.getError())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(processRunner.getError());
        }
        return StringUtils.trin(stringBuilder.toString().replace('\n', ' '));
    }

    private String[] getCommandLine() {
        return new String[]{this.dotExe.getAbsolutePath(), "-V"};
    }
}

