/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LongCode;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.SingleStrategy;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EntityImpl
implements ILeaf,
IGroup {
    private final EntityFactory entityFactory;
    private final Code code;
    private final LongCode longCode;
    private Url url;
    private final Bodier bodier;
    private final String uid = StringUtils.getUid("cl", UniqueSequence.getValue());
    private Display display = Display.empty();
    private LeafType leafType;
    private Stereotype stereotype;
    private String generic;
    private IGroup parentContainer;
    private boolean top;
    private Code namespace2;
    private GroupType groupType;
    private boolean nearDecoration = false;
    private final Collection<String> portShortNames = new HashSet<String>();
    private int xposition;
    private IEntityImage svekImage;
    private boolean removed = false;
    private USymbol symbol;
    private final int rawLayout;
    private char concurrentSeparator;
    private int layer;
    private Neighborhood neighborhood;
    private final Map<String, Display> tips = new LinkedHashMap<String, Display>();
    private Colors colors = Colors.empty();
    private VisibilityModifier visibility;

    @Override
    public final boolean isTop() {
        this.checkNotGroup();
        return this.top;
    }

    @Override
    public final void setTop(boolean bl) {
        this.checkNotGroup();
        this.top = bl;
    }

    private EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup iGroup, LongCode longCode, String string, int n) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        this.entityFactory = entityFactory;
        this.bodier = bodier;
        this.code = code;
        this.parentContainer = iGroup;
        this.longCode = longCode;
        this.rawLayout = n;
    }

    EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup iGroup, LeafType leafType, LongCode longCode, String string, int n) {
        this(entityFactory, code, bodier, iGroup, longCode, string, n);
        this.leafType = leafType;
    }

    EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup iGroup, GroupType groupType, Code code2, LongCode longCode, String string, int n) {
        this(entityFactory, code, bodier, iGroup, longCode, string, n);
        this.groupType = groupType;
        this.namespace2 = code2;
    }

    @Override
    public void setContainer(IGroup iGroup) {
        this.checkNotGroup();
        if (iGroup == null) {
            throw new IllegalArgumentException();
        }
        this.parentContainer = iGroup;
    }

    @Override
    public LeafType getLeafType() {
        return this.leafType;
    }

    @Override
    public boolean muteToType(LeafType leafType, USymbol uSymbol) {
        this.checkNotGroup();
        if (leafType == null) {
            throw new IllegalArgumentException();
        }
        if (this.leafType != LeafType.STILL_UNKNOWN) {
            if (this.leafType != LeafType.ANNOTATION && this.leafType != LeafType.ABSTRACT_CLASS && this.leafType != LeafType.CLASS && this.leafType != LeafType.ENUM && this.leafType != LeafType.INTERFACE) {
                return false;
            }
            if (leafType != LeafType.ANNOTATION && leafType != LeafType.ABSTRACT_CLASS && leafType != LeafType.CLASS && leafType != LeafType.ENUM && leafType != LeafType.INTERFACE && leafType != LeafType.OBJECT) {
                return false;
            }
        }
        if (this.leafType == LeafType.CLASS && leafType == LeafType.OBJECT) {
            this.bodier.muteClassToObject();
        }
        this.leafType = leafType;
        this.symbol = uSymbol;
        return true;
    }

    @Override
    public Code getCode() {
        return this.code;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(Display display) {
        this.display = display;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public final void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final IGroup getParentContainer() {
        if (this.parentContainer == null) {
            throw new IllegalArgumentException();
        }
        return this.parentContainer;
    }

    public String toString() {
        return this.code + " " + this.display + "(" + (Object)((Object)this.leafType) + ") " + this.xposition + " " + this.getUid();
    }

    @Override
    public final Url getUrl99() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        if (!Display.isNull(this.display) && this.display.hasUrl()) {
            return true;
        }
        if (this.bodier.hasUrl()) {
            return true;
        }
        return this.url != null;
    }

    @Override
    public final void addUrl(Url url) {
        this.url = url;
    }

    @Override
    public final boolean hasNearDecoration() {
        this.checkNotGroup();
        return this.nearDecoration;
    }

    @Override
    public final void setNearDecoration(boolean bl) {
        this.nearDecoration = bl;
    }

    @Override
    public int getXposition() {
        this.checkNotGroup();
        return this.xposition;
    }

    @Override
    public void setXposition(int n) {
        this.checkNotGroup();
        this.xposition = n;
    }

    @Override
    public final IEntityImage getSvekImage() {
        this.checkNotGroup();
        return this.svekImage;
    }

    @Override
    public final void setSvekImage(IEntityImage iEntityImage) {
        this.checkNotGroup();
        this.svekImage = iEntityImage;
    }

    @Override
    public final void setGeneric(String string) {
        this.checkNotGroup();
        this.generic = string;
    }

    @Override
    public final String getGeneric() {
        this.checkNotGroup();
        return this.generic;
    }

    @Override
    public Bodier getBodier() {
        return this.bodier;
    }

    @Override
    public EntityPosition getEntityPosition() {
        this.checkNotGroup();
        if (this.leafType != LeafType.STATE) {
            return EntityPosition.NORMAL;
        }
        if (this.getParentContainer() instanceof GroupRoot) {
            return EntityPosition.NORMAL;
        }
        Stereotype stereotype = this.getStereotype();
        if (stereotype == null) {
            return EntityPosition.NORMAL;
        }
        return EntityPosition.fromStereotype(stereotype.getLabel(false));
    }

    private void checkGroup() {
        if (!this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkNotGroup() {
        if (this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean containsLeafRecurse(ILeaf iLeaf) {
        if (iLeaf == null) {
            throw new IllegalArgumentException();
        }
        if (iLeaf.isGroup()) {
            throw new IllegalArgumentException();
        }
        this.checkGroup();
        if (iLeaf.getParentContainer() == this) {
            return true;
        }
        for (IGroup iGroup : this.getChildren()) {
            if (!iGroup.containsLeafRecurse(iLeaf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ILeaf> getLeafsDirect() {
        this.checkGroup();
        ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
        for (ILeaf iLeaf : this.entityFactory.getLeafs().values()) {
            if (iLeaf.isGroup()) {
                throw new IllegalStateException();
            }
            if (iLeaf.getParentContainer() != this) continue;
            arrayList.add(iLeaf);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public Collection<IGroup> getChildren() {
        this.checkGroup();
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        for (IGroup iGroup : this.entityFactory.getGroups().values()) {
            if (iGroup == this || iGroup.getParentContainer() != this) continue;
            arrayList.add(iGroup);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public void moveEntitiesTo(IGroup iGroup) {
        this.checkGroup();
        if (!iGroup.isGroup()) {
            throw new UnsupportedOperationException();
        }
        for (ILeaf iEntity : this.getLeafsDirect()) {
            ((EntityImpl)iEntity).parentContainer = iGroup;
        }
        Iterator<IEntity> iterator = iGroup.getChildren().iterator();
        if (iterator.hasNext()) {
            IGroup iGroup2 = (IGroup)iterator.next();
            throw new IllegalStateException();
        }
        for (IGroup iGroup3 : this.getChildren()) {
            if (iGroup3 == iGroup) continue;
            ((EntityImpl)iGroup3).parentContainer = iGroup;
        }
    }

    @Override
    public int size() {
        this.checkGroup();
        return this.getLeafsDirect().size();
    }

    @Override
    public GroupType getGroupType() {
        this.checkGroup();
        return this.groupType;
    }

    @Override
    public Code getNamespace2() {
        this.checkGroup();
        return this.namespace2;
    }

    @Override
    public PackageStyle getPackageStyle() {
        this.checkGroup();
        if (this.stereotype == null) {
            return null;
        }
        return this.stereotype.getPackageStyle();
    }

    @Override
    public boolean isGroup() {
        if (this.groupType != null && this.leafType != null) {
            throw new IllegalStateException();
        }
        if (this.groupType != null) {
            return true;
        }
        if (this.leafType != null) {
            return false;
        }
        throw new IllegalStateException();
    }

    @Override
    public void overrideImage(IEntityImage iEntityImage, LeafType leafType) {
        this.checkGroup();
        this.svekImage = iEntityImage;
        this.url = null;
        for (Link removeable : new ArrayList<Link>(this.entityFactory.getLinks())) {
            if (!EntityUtils.isPureInnerLink12(this, removeable)) continue;
            this.entityFactory.removeLink(removeable);
        }
        this.entityFactory.removeGroup(this.getCode());
        for (ILeaf iLeaf : new ArrayList<ILeaf>(this.entityFactory.getLeafs().values())) {
            if (this == iLeaf || this != iLeaf.getParentContainer()) continue;
            this.entityFactory.removeLeaf(iLeaf.getCode());
        }
        this.entityFactory.addLeaf(this);
        this.groupType = null;
        this.leafType = leafType;
    }

    void muteToGroup(Code code, GroupType groupType, IGroup iGroup) {
        this.checkNotGroup();
        if (!iGroup.isGroup()) {
            throw new IllegalArgumentException();
        }
        this.namespace2 = code;
        this.groupType = groupType;
        this.leafType = null;
        this.parentContainer = iGroup;
    }

    @Override
    public boolean isHidden() {
        if (this.entityFactory.isHidden(this)) {
            return true;
        }
        if (this.stereotype != null) {
            return this.stereotype.isHidden();
        }
        return false;
    }

    @Override
    public USymbol getUSymbol() {
        if (this.getLeafType() == LeafType.CIRCLE) {
            return USymbol.INTERFACE;
        }
        if (this.symbol != null && this.stereotype != null && this.stereotype.getSprite() != null) {
            return this.symbol.withStereoAlignment(HorizontalAlignment.RIGHT);
        }
        return this.symbol;
    }

    @Override
    public void setUSymbol(USymbol uSymbol) {
        this.symbol = uSymbol;
    }

    @Override
    public SingleStrategy getSingleStrategy() {
        return SingleStrategy.SQUARRE;
    }

    @Override
    public boolean isRemoved() {
        if (this.isGroup()) {
            if (this.removed) {
                return true;
            }
            if (this.getLeafsDirect().size() == 0) {
                return false;
            }
            for (ILeaf iEntity : this.getLeafsDirect()) {
                if (iEntity.isRemoved()) continue;
                return false;
            }
            for (IGroup iGroup : this.getChildren()) {
                if (iGroup.isRemoved()) continue;
                return false;
            }
            return true;
        }
        return this.removed;
    }

    @Override
    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @Override
    public int getHectorLayer() {
        return this.layer;
    }

    @Override
    public void setHectorLayer(int n) {
        this.layer = n;
        if (n > 1000) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public LongCode getLongCode() {
        return this.longCode;
    }

    private FontParam getTitleFontParam() {
        if (this.symbol != null) {
            return this.symbol.getFontParam();
        }
        return this.getGroupType() == GroupType.STATE ? FontParam.STATE : FontParam.PACKAGE;
    }

    @Override
    public FontConfiguration getFontConfigurationForTitle(ISkinParam iSkinParam) {
        FontParam fontParam = this.getTitleFontParam();
        HtmlColor htmlColor = iSkinParam.getFontHtmlColor(this.getStereotype(), fontParam, FontParam.PACKAGE);
        UFont uFont = iSkinParam.getFont(this.getStereotype(), true, fontParam, FontParam.PACKAGE);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, htmlColor, iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink(), iSkinParam.getTabSize());
        return fontConfiguration;
    }

    @Override
    public final int getRawLayout() {
        return this.rawLayout;
    }

    @Override
    public char getConcurrentSeparator() {
        return this.concurrentSeparator;
    }

    @Override
    public void setConcurrentSeparator(char c) {
        this.concurrentSeparator = c;
    }

    @Override
    public void setNeighborhood(Neighborhood neighborhood) {
        this.neighborhood = neighborhood;
    }

    @Override
    public Neighborhood getNeighborhood() {
        return this.neighborhood;
    }

    @Override
    public void putTip(String string, Display display) {
        this.tips.put(string, display);
    }

    @Override
    public Map<String, Display> getTips() {
        return Collections.unmodifiableMap(this.tips);
    }

    @Override
    public Colors getColors(ISkinParam iSkinParam) {
        return this.colors;
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    @Override
    public void setSpecificColorTOBEREMOVED(ColorType colorType, HtmlColor htmlColor) {
        if (htmlColor != null) {
            this.colors = this.colors.add(colorType, htmlColor);
        }
    }

    @Override
    public Collection<String> getPortShortNames() {
        this.checkNotGroup();
        return Collections.unmodifiableCollection(this.portShortNames);
    }

    @Override
    public void addPortShortName(String string) {
        this.portShortNames.add(string);
    }

    @Override
    public void setVisibilityModifier(VisibilityModifier visibilityModifier) {
        this.visibility = visibilityModifier;
    }

    @Override
    public VisibilityModifier getVisibilityModifier() {
        return this.visibility;
    }
}

