/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.cute.InfiniteLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossingSimple {
    private final double radius;
    private final InfiniteLine line;

    public CrossingSimple(double d, InfiniteLine infiniteLine) {
        this.radius = d;
        this.line = infiniteLine;
    }

    private double pow2(double d) {
        return d * d;
    }

    private double sgn(double d) {
        if (d < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public List<Point2D> intersection() {
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        double d = this.pow2(this.radius * this.line.getDr()) - this.pow2(this.line.getDiscriminant());
        if (d < 0.0) {
            return arrayList;
        }
        double d2 = (this.line.getDiscriminant() * this.line.getDeltaY() + this.sgn(this.line.getDeltaY()) * this.line.getDeltaX() * Math.sqrt(d)) / this.pow2(this.line.getDr());
        double d3 = (-this.line.getDiscriminant() * this.line.getDeltaX() + Math.abs(this.line.getDeltaY()) * Math.sqrt(d)) / this.pow2(this.line.getDr());
        arrayList.add(new Point2D.Double(d2, d3));
        d2 = (this.line.getDiscriminant() * this.line.getDeltaY() - this.sgn(this.line.getDeltaY()) * this.line.getDeltaX() * Math.sqrt(d)) / this.pow2(this.line.getDr());
        d3 = (-this.line.getDiscriminant() * this.line.getDeltaX() - Math.abs(this.line.getDeltaY()) * Math.sqrt(d)) / this.pow2(this.line.getDr());
        arrayList.add(new Point2D.Double(d2, d3));
        return arrayList;
    }
}

