/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.cute.RotationZoom;

public class MyDouble {
    private static final double NO_CURVE = Double.MIN_VALUE;
    private final double value;
    private final double curvation;

    public MyDouble(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.value = Double.parseDouble(stringTokenizer.nextToken());
        this.curvation = stringTokenizer.hasMoreTokens() ? Double.parseDouble(stringTokenizer.nextToken()) : Double.MIN_VALUE;
    }

    public String toString() {
        return this.value + "[" + this.curvation + "]";
    }

    private MyDouble(double d, double d2) {
        this.value = d;
        this.curvation = d2;
    }

    public double getCurvation(double d) {
        if (this.curvation == Double.MIN_VALUE) {
            return d;
        }
        return this.curvation;
    }

    public double getValue() {
        return this.value;
    }

    public boolean hasCurvation() {
        return this.curvation != Double.MIN_VALUE;
    }

    public MyDouble rotateZoom(RotationZoom rotationZoom) {
        double d = rotationZoom.applyZoom(this.value);
        double d2 = this.curvation == Double.MIN_VALUE ? Double.MIN_VALUE : rotationZoom.applyZoom(this.curvation);
        return new MyDouble(d, d2);
    }

    public MyDouble toRadians() {
        return new MyDouble(Math.toRadians(this.value), this.curvation);
    }
}

