/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import net.sourceforge.plantuml.cute.CuteShape;
import net.sourceforge.plantuml.cute.Group;
import net.sourceforge.plantuml.cute.Positionned;
import net.sourceforge.plantuml.cute.RotationZoom;
import net.sourceforge.plantuml.cute.VarArgs;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class PositionnedImpl
implements Positionned {
    private final CuteShape cuteShape;
    private final HtmlColor color;
    private final UTranslate position;
    private final RotationZoom rotationZoom;

    public String toString() {
        return "Positionned " + this.position + " " + this.cuteShape;
    }

    public PositionnedImpl(CuteShape cuteShape, VarArgs varArgs) {
        this.cuteShape = cuteShape;
        this.color = varArgs.getAsColor("color");
        this.position = varArgs.getPosition();
        this.rotationZoom = RotationZoom.fromVarArgs(varArgs);
    }

    private PositionnedImpl(CuteShape cuteShape, HtmlColor htmlColor, UTranslate uTranslate, RotationZoom rotationZoom) {
        this.cuteShape = cuteShape;
        this.color = htmlColor;
        this.position = uTranslate;
        this.rotationZoom = rotationZoom;
    }

    public PositionnedImpl(Group group, RotationZoom rotationZoom) {
        this.cuteShape = group;
        this.color = HtmlColorUtils.BLACK;
        this.position = new UTranslate();
        this.rotationZoom = rotationZoom;
    }

    public PositionnedImpl(Group group, UTranslate uTranslate) {
        this.cuteShape = group;
        this.color = HtmlColorUtils.BLACK;
        this.position = uTranslate;
        this.rotationZoom = RotationZoom.none();
    }

    private UGraphic applyColor(UGraphic uGraphic) {
        return uGraphic.apply(new UChangeBackColor(this.color)).apply(new UChangeColor(this.color));
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic = this.applyColor(uGraphic);
        uGraphic = uGraphic.apply(this.position);
        CuteShape cuteShape = this.rotationZoom.isNone() ? this.cuteShape : this.cuteShape.rotateZoom(this.rotationZoom);
        cuteShape.drawU(uGraphic);
    }

    public Positionned rotateZoom(RotationZoom rotationZoom) {
        return new PositionnedImpl(this.cuteShape, this.color, rotationZoom.getUTranslate(this.position), this.rotationZoom.compose(rotationZoom));
    }

    public Positionned translate(UTranslate uTranslate) {
        return new PositionnedImpl(this.cuteShape, this.color, this.position.compose(uTranslate), this.rotationZoom);
    }
}

