/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.cute.CutePath;
import net.sourceforge.plantuml.cute.MyDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class VarArgs {
    private final Map<String, String> args = new HashMap<String, String>();

    public VarArgs(String string) {
        for (String string2 : string.split("\\s")) {
            if (!string2.contains("=")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            this.args.put(string3, string4);
        }
    }

    public String toString() {
        return this.args.toString();
    }

    public double getAsDouble(String string, double d) {
        if (this.args.containsKey(string)) {
            return this.getAsDouble(string);
        }
        return d;
    }

    public double getAsDouble(String string) {
        String string2 = this.args.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("no key " + string);
        }
        return Double.parseDouble(string2);
    }

    public MyDouble getAsMyDouble(String string) {
        String string2 = this.args.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("no key " + string);
        }
        return new MyDouble(string2);
    }

    public HtmlColor getAsColor(String string) {
        String string2 = this.args.get(string);
        if (string2 == null) {
            return HtmlColorUtils.BLACK;
        }
        HtmlColor htmlColor = HtmlColorSet.getInstance().getColorIfValid(string2);
        if (htmlColor == null) {
            return HtmlColorUtils.BLACK;
        }
        return htmlColor;
    }

    public Point2D getAsPoint(String string) {
        String string2 = this.args.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("no key " + string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2.replaceAll("[()]", ""), ",");
        return new Point2D.Double(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()));
    }

    public Point2D getAsPoint(String string, Point2D point2D) {
        if (this.args.containsKey(string)) {
            return this.getAsPoint(string);
        }
        return point2D;
    }

    public CutePath getPointList(String string) {
        String string2 = this.args.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("no key " + string);
        }
        return new CutePath(string2);
    }

    public UTranslate getPosition() {
        return new UTranslate(this.getAsPoint("position", new Point2D.Double()));
    }
}

