/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.SignatureUtils;
import net.sourceforge.plantuml.dedication.Dedication;

public class Dedications {
    private static final Map<String, Dedication> normal = new HashMap<String, Dedication>();
    private static final Map<String, Dedication> crypted = new HashMap<String, Dedication>();

    private static void addNormal(String string, String string2) {
        normal.put(Dedications.keepLetter(string), new Dedication(string2));
    }

    private static void addCrypted(String string, String string2) {
        crypted.put(string2, new Dedication(string));
    }

    private Dedications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dedication get(String string) {
        String string2 = Dedications.keepLetter(string);
        Dedication dedication = normal.get(string2);
        if (dedication != null) {
            return dedication;
        }
        for (Map.Entry<String, Dedication> entry : crypted.entrySet()) {
            Dedication dedication2 = entry.getValue();
            InputStream inputStream = null;
            try {
                inputStream = dedication2.getInputStream(string2);
                String string3 = SignatureUtils.getSignatureSha512(inputStream);
                if (!string3.equals(entry.getKey())) continue;
                Dedication dedication3 = dedication2;
                return dedication3;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String keepLetter(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static {
        Dedications.addNormal("Write your own dedication!", "dedication");
        Dedications.addNormal("linux_china", "linux_china");
        Dedications.addCrypted("0", "pOhci6rKgPXw32AeYXhOpSY0suoauHq5VUSwFqHLHsLYgSO6WaJ7BW5vtHBAoU6ePbcW7d8Flx99MWjPSKQTDm00");
    }
}

