/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class QBlock {
    private final BigInteger big;

    public static QBlock read(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n + 1];
        for (int i = 0; i < n; ++i) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                if (i != 0) break;
                return null;
            }
            byArray[i + 1] = (byte)n2;
        }
        return new QBlock(new BigInteger(byArray));
    }

    public QBlock(BigInteger bigInteger) {
        this.big = bigInteger;
    }

    public QBlock change(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.big.modPow(bigInteger, bigInteger2);
        return new QBlock(bigInteger3);
    }

    public byte[] getData() {
        return this.big.toByteArray();
    }

    public String toString() {
        return this.big.toByteArray().length + " " + this.big.toString();
    }

    public void write(OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = this.big.toByteArray();
        int n3 = byArray.length - n;
        if (n3 < 0) {
            for (n2 = 0; n2 < -n3; ++n2) {
                outputStream.write(0);
            }
        }
        for (n2 = Math.max(n3, 0); n2 < byArray.length; ++n2) {
            byte by = byArray[n2];
            outputStream.write(by);
        }
    }
}

