/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.descdiagram.command.CommandCreateElementFull;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateElementMultilines
extends CommandMultilines2<DescriptionDiagram> {
    private final int type;

    public CommandCreateElementMultilines(int n) {
        super(CommandCreateElementMultilines.getRegexConcat(n), MultilinesStrategy.REMOVE_STARTING_QUOTE);
        this.type = n;
    }

    @Override
    public String getPatternEnd() {
        if (this.type == 0) {
            return "(?i)^(.*)[%g]$";
        }
        if (this.type == 1) {
            return "(?i)^(.*)\\]$";
        }
        throw new IllegalArgumentException();
    }

    private static RegexConcat getRegexConcat(int n) {
        if (n == 0) {
            return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(artifact|actor|folder|card|file|package|rectangle|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle)[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*"), new RegexLeaf("DESC", "as[%s]*[%g](.*)$"));
        }
        if (n == 1) {
            return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(artifact|actor|folder|card|file|package|rectangle|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle)[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<\\<.+\\>\\>)?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*"), new RegexLeaf("DESC", "\\[(.*)$"));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public CommandExecutionResult executeNow(DescriptionDiagram descriptionDiagram, BlocLines blocLines) {
        USymbol uSymbol;
        LeafType leafType;
        blocLines = blocLines.trim(false);
        RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
        String string = StringUtils.goUpperCase(regexResult.get("TYPE", 0));
        if (string.equalsIgnoreCase("usecase")) {
            leafType = LeafType.USECASE;
            uSymbol = null;
        } else {
            uSymbol = USymbol.getFromString(string);
            if (uSymbol == null) {
                throw new IllegalStateException();
            }
            leafType = LeafType.DESCRIPTION;
        }
        Code code = Code.of(regexResult.get("CODE", 0));
        List<String> list = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), blocLines.getLast499().toString());
        blocLines = blocLines.subExtract(1, 1);
        Display display = blocLines.toDisplay();
        String string2 = regexResult.get("DESC", 0);
        if (StringUtils.isNotEmpty(string2)) {
            display = display.addFirst(string2);
        }
        if (StringUtils.isNotEmpty(list.get(0))) {
            display = display.add(list.get(0));
        }
        String string3 = regexResult.get("STEREO", 0);
        if (CommandCreateElementFull.existsWithBadType(descriptionDiagram, code, leafType, uSymbol)) {
            return CommandExecutionResult.error("This element (" + code.getFullName() + ") is already defined");
        }
        ILeaf iLeaf = descriptionDiagram.createLeaf(code, display, leafType, uSymbol);
        iLeaf.setUSymbol(uSymbol);
        if (string3 != null) {
            iLeaf.setStereotype(new Stereotype(string3, descriptionDiagram.getSkinParam().getCircledCharacterRadius(), descriptionDiagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), descriptionDiagram.getSkinParam().getIHtmlColorSet()));
        }
        iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, descriptionDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

