/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemDitaaFactory
extends PSystemBasicFactory<PSystemDitaa> {
    public PSystemDitaaFactory(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public PSystemDitaa init(String string) {
        boolean bl = true;
        if (string != null && (string.contains("-E") || string.contains("--no-separation"))) {
            bl = false;
        }
        boolean bl2 = true;
        if (string != null && (string.contains("-S") || string.contains("--no-shadows"))) {
            bl2 = false;
        }
        float f = this.extractScale(string);
        if (this.getDiagramType() == DiagramType.UML) {
            return null;
        }
        if (this.getDiagramType() == DiagramType.DITAA) {
            return new PSystemDitaa("", bl, bl2, f);
        }
        throw new IllegalStateException(this.getDiagramType().name());
    }

    @Override
    public PSystemDitaa executeLine(PSystemDitaa pSystemDitaa, String string) {
        if (pSystemDitaa == null && (string.equals("ditaa") || string.startsWith("ditaa("))) {
            boolean bl = true;
            if (string.contains("-E") || string.contains("--no-separation")) {
                bl = false;
            }
            boolean bl2 = true;
            if (string.contains("-S") || string.contains("--no-shadows")) {
                bl2 = false;
            }
            float f = this.extractScale(string);
            return new PSystemDitaa("", bl, bl2, f);
        }
        if (pSystemDitaa == null) {
            return null;
        }
        return pSystemDitaa.add(string);
    }

    private float extractScale(String string) {
        if (string == null) {
            return 1.0f;
        }
        Pattern pattern = Pattern.compile("scale=([\\d.]+)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            return Float.parseFloat(string2);
        }
        return 1.0f;
    }
}

