/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "UDfbL4jksp0GtSyfk1RIGoXsujI_17QQ0jcDvR75c29Tad8ghuBUe421hdk3eaKMHOjiUW7bHXsvbKcb10oOud3clPdtcAhato8BL-J9YbHxeoLcS4r9MAQ0iGbRwo1jh-821ZOSKGLpMg3p4hMOcbn3gfV6Ye4XlwVcxsh54MquQXXZL4XxwCjs8nMa8RNPmRmC42eOoAIxj85XYx9qCFUqpKcBdZ5RvjTlwv23KV7Ygh7GCqfgCJEb8nYMBywJEyD4sirMmYH2ZKMyvLAfelUebzpENYuvwnfjnKndHzfw3TCOlT_3fP8xlj2NsOQH7q-aXZDtJAqZ40djeBylfBUL66DkbWZ3fkctENBwA2uX5SR5QrDncpHwZcDyZ6lu5pnjEgpqahSsuvwSuy9M6tFlDf8JARvsQRtSmqM8NXgOo2md9KvHgYfceFOn6ETWIAXV3J5xLv8J_N9XaMUf0jyRS-SfoyN8eiC0QKqiqMXYzusoE4ICp4x6GZb8vKqWB15caNYR4Z7Fv8vlRoDPcKtJcLDZKQFQdeXRycYs3cPC4ErIZ6GpMZXNnZRzdlp-fTHXw44GAX8dosbyb9F5jjlDrFCk8mTNsCfZ9Zk0KoN57779rh5h4cz9hycUY4bw_NgU1cadHiE0EfQ9cUkC9LA86qRTPz6EGgIbPh9ibZ4HdErYvUyGfY495It89A8nA2NheYn8d9kIVEXlvk0ydio1Ir23tiTjOxXJkMODpMKHBCY0sCchfjF8hev09qf1_Qb-ZDBNZ_KFwEKTQrTil79nU0YiPYzSc0wS0PdLob8bfhBWmGtn_rTbXYjKOb8vnHwflzIFpm_rzwQKg3_NJ_NF-kdv0_yU-DCtEBEq5oDK1Jlh8fvr8rTYlPwIQWvrD3Qk8gDNCKduaUooO87TqCj7AIaLlnij5G_pGqBdeVvOVpssX86nvqAUQxEG3AEFjeXzoY8my0TY-gPS";

    @Override
    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        UDrawable uDrawable = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(uDrawable);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, l, outputStream);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> list = PSystemDonors.getCols(this.getDonors(), 4, 5);
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                TextBlockBackcolored textBlockBackcolored = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                textBlockBackcolored.drawU(uGraphic);
                StringBounder stringBounder = uGraphic.getStringBounder();
                uGraphic = uGraphic.apply(new UTranslate(0.0, textBlockBackcolored.calculateDimension(stringBounder).getHeight()));
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (TextBlock textBlock : list) {
                    Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                    textBlock.drawU(uGraphic.apply(new UTranslate(d, 0.0)));
                    d2 = d;
                    d += dimension2D.getWidth() + 10.0;
                    d3 = Math.max(d3, dimension2D.getHeight());
                }
                UImage uImage = new UImage(PSystemVersion.getPlantumlImage());
                uGraphic.apply(new UTranslate(d2, d3 - uImage.getHeight())).draw(uImage);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> list, int n, int n2) throws IOException {
        ArrayList<TextBlock> arrayList = new ArrayList<TextBlock>();
        int n3 = (list.size() + (n - 1) + n2) / n;
        for (int i = 0; i < list.size(); i += n3) {
            List<String> list2 = list.subList(i, Math.min(list.size(), i + n3));
            arrayList.add(GraphicStrings.createBlackOnWhite(list2));
        }
        return arrayList;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        TranscoderImpl transcoderImpl = new TranscoderImpl();
        String string = transcoderImpl.decode(DONORS).replace('*', '.');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

