/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eps;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.eps.PostScriptCommandMacro;
import net.sourceforge.plantuml.eps.PostScriptCommandRaw;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ShadowManager;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.version.Version;

public class EpsGraphics {
    public static final String END_OF_FILE = "%plantuml done";
    private final StringBuilder body = new StringBuilder();
    private final StringBuilder header = new StringBuilder();
    private Color color = Color.BLACK;
    private Color fillcolor = Color.BLACK;
    private String strokeWidth = "1";
    private final PostScriptCommandMacro setcolorgradient = new PostScriptCommandMacro("setcolorgradient");
    private final PostScriptCommandMacro simplerect = new PostScriptCommandMacro("simplerect");
    private final PostScriptCommandMacro roundrect = new PostScriptCommandMacro("roundrect");
    private boolean setcolorgradientUsed = false;
    private boolean simplerectUsed = false;
    private boolean roundrectUsed = false;
    private boolean closeDone = false;
    private int maxX = 10;
    private int maxY = 10;
    private double dashVisible = 0.0;
    private double dashSpace = 0.0;
    private UrlArea urlArea;
    private final ShadowManager shadowManager = new ShadowManager(50, 200);

    public EpsGraphics() {
        this.header.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        this.header.append("%%Creator: PlantUML v" + Version.versionString(15) + "\n");
        this.header.append("%%Title: noTitle\n");
        this.setcolorgradient.add(new PostScriptCommandRaw("3 index 7 index sub 1 index mul 7 index add", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("3 index 7 index sub 2 index mul 7 index add", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("3 index 7 index sub 3 index mul 7 index add", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("setrgbcolor", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("pop pop pop pop pop pop pop ", true));
        this.simplerect.add(new PostScriptCommandRaw("newpath moveto 1 index 0 rlineto", true));
        this.simplerect.add(new PostScriptCommandRaw("0 exch rlineto", true));
        this.simplerect.add(new PostScriptCommandRaw("neg 0 rlineto", true));
        this.roundrect.add(new PostScriptCommandRaw("newpath", true));
        this.roundrect.add(new PostScriptCommandRaw("dup 3 index add 2 index 2 index add 2 index 180 270 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("2 index 5 index add 1 index sub 2 index 2 index add 2 index 270 0 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("2 index 5 index add 1 index sub 2 index 5 index add 2 index sub 2 index 0 90 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("dup 3 index add 2 index 5 index add 2 index sub 2 index 90 180 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("pop pop pop pop pop ", true));
    }

    protected final void ensureVisible(double d, double d2) {
        if (d > (double)this.maxX) {
            this.maxX = (int)(d + 1.0);
        }
        if (d2 > (double)this.maxY) {
            this.maxY = (int)(d2 + 1.0);
        }
        if (this.urlArea != null) {
            this.urlArea.ensureVisible((int)Math.round(d), (int)Math.round(d2));
        }
    }

    protected final Color getColor() {
        return this.color;
    }

    public void close() {
        this.checkCloseDone();
        this.header.append("%%BoundingBox: 0 0 " + this.maxX + " " + this.maxY + "\n");
        this.header.append("%%ColorUsage: Color\n");
        this.header.append("%%Origin: 0 0\n");
        this.header.append("%%EndComments\n\n");
        this.header.append("gsave\n");
        this.header.append("0 " + this.maxY + " translate\n");
        this.header.append("1 -1 scale\n");
        if (this.setcolorgradientUsed) {
            this.header.append(this.setcolorgradient.getPostStringDefinition());
        }
        if (this.simplerectUsed) {
            this.header.append(this.simplerect.getPostStringDefinition());
        }
        if (this.roundrectUsed) {
            this.header.append(this.roundrect.getPostStringDefinition());
        }
        this.append("grestore", true);
        this.append("showpage", true);
        this.append(END_OF_FILE, true);
        this.append("%%EOF", true);
        this.closeDone = true;
    }

    private void checkCloseDone() {
        if (this.closeDone) {
            throw new IllegalStateException();
        }
    }

    public String getEPSCode() {
        if (!this.closeDone) {
            this.close();
        }
        return this.header.toString() + this.getBodyString();
    }

    protected String getBodyString() {
        return this.body.toString();
    }

    public final void setStrokeColor(Color color) {
        this.checkCloseDone();
        this.color = color;
    }

    public void setFillColor(Color color) {
        this.checkCloseDone();
        this.fillcolor = color;
    }

    public final void setStrokeWidth(String string, double d, double d2) {
        this.checkCloseDone();
        this.strokeWidth = string;
        this.dashVisible = d;
        this.dashSpace = d2;
    }

    public void newpathDot() {
        boolean bl = this.dashVisible != 0.0 || this.dashSpace != 0.0;
        this.checkCloseDone();
        this.append(this.strokeWidth + " setlinewidth", true);
        this.appendColor(this.color);
        if (bl) {
            this.append("[9 9] 0 setdash", true);
        }
        this.append("newpath", true);
    }

    public void closepathDot() {
        boolean bl = this.dashVisible != 0.0 || this.dashSpace != 0.0;
        this.append("stroke", true);
        if (bl) {
            this.append("[] 0 setdash", true);
        }
    }

    public void epsLine(double d, double d2, double d3, double d4) {
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
        this.checkCloseDone();
        this.append(this.strokeWidth + " setlinewidth", true);
        this.appendColor(this.color);
        this.append("newpath", true);
        if (this.dashVisible == 0.0 || this.dashSpace == 0.0) {
            this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " moveto", true);
            this.append(EpsGraphics.format(d3 - d) + " " + EpsGraphics.format(d4 - d2) + " rlineto", true);
        } else if (d == d3) {
            this.epsHLine(d, Math.min(d2, d4), Math.max(d2, d4));
        } else if (d2 == d4) {
            this.epsVLine(d2, Math.min(d, d3), Math.max(d, d3));
        }
        this.append("stroke", true);
        this.ensureVisible(Math.max(d, d3), Math.max(d2, d4));
    }

    protected void epsHLine(double d, double d2, double d3) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " moveto", true);
        for (double d4 = d2; d4 < d3; d4 += this.dashVisible + this.dashSpace) {
            double d5 = d4 + this.dashVisible > d3 ? d4 - d3 : this.dashSpace;
            this.append("0 " + EpsGraphics.format(d5) + " rlineto", true);
            this.append("0 " + EpsGraphics.format(this.dashSpace) + " rmoveto", true);
        }
    }

    protected void epsVLine(double d, double d2, double d3) {
        this.append(EpsGraphics.format(d2) + " " + EpsGraphics.format(d) + " moveto", true);
        for (double d4 = d2; d4 < d3; d4 += this.dashVisible + this.dashSpace) {
            double d5 = d4 + this.dashVisible > d3 ? d4 - d3 : this.dashSpace;
            this.append(EpsGraphics.format(d5) + " 0 rlineto", true);
            this.append(EpsGraphics.format(this.dashSpace) + " 0 rmoveto", true);
        }
    }

    public void epsPath(double d, double d2, UPath uPath) {
        double[] dArray;
        USegmentType uSegmentType;
        this.checkCloseDone();
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.append("newpath", true);
            for (USegment uSegment : uPath) {
                uSegmentType = uSegment.getSegmentType();
                dArray = uSegment.getCoord();
                if (uSegmentType == USegmentType.SEG_MOVETO) {
                    this.movetoNoMacro(dArray[0] + d, dArray[1] + d2);
                    continue;
                }
                if (uSegmentType == USegmentType.SEG_LINETO) {
                    this.linetoNoMacro(dArray[0] + d, dArray[1] + d2);
                    continue;
                }
                if (uSegmentType == USegmentType.SEG_QUADTO) {
                    throw new UnsupportedOperationException();
                }
                if (uSegmentType == USegmentType.SEG_CUBICTO) {
                    this.curvetoNoMacro(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2, dArray[4] + d, dArray[5] + d2);
                    continue;
                }
                if (uSegmentType == USegmentType.SEG_CLOSE) continue;
                Log.println("unknown " + uSegment);
            }
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            for (USegment uSegment : uPath) {
                uSegmentType = uSegment.getSegmentType();
                dArray = uSegment.getCoord();
                if (uSegmentType == USegmentType.SEG_MOVETO) {
                    this.movetoNoMacro(dArray[0] + d, dArray[1] + d2);
                    continue;
                }
                if (uSegmentType == USegmentType.SEG_LINETO) {
                    this.linetoNoMacro(dArray[0] + d, dArray[1] + d2);
                    continue;
                }
                if (uSegmentType == USegmentType.SEG_QUADTO) {
                    throw new UnsupportedOperationException();
                }
                if (uSegmentType == USegmentType.SEG_CUBICTO) {
                    this.curvetoNoMacro(dArray[0] + d, dArray[1] + d2, dArray[2] + d, dArray[3] + d2, dArray[4] + d, dArray[5] + d2);
                    continue;
                }
                if (uSegmentType == USegmentType.SEG_CLOSE) continue;
                Log.println("unknown " + uSegment);
            }
            this.append("stroke", true);
        }
    }

    public void epsPolygon(HtmlColorGradient htmlColorGradient, ColorMapper colorMapper, double ... dArray) {
        this.setFillColor(colorMapper.getMappedColor(htmlColorGradient.getColor1()));
        this.epsPolygon(dArray);
    }

    public void epsPolygon(double ... dArray) {
        int n;
        this.checkCloseDone();
        double d = 0.0;
        double d2 = 0.0;
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.append("newpath", true);
            for (n = 0; n < dArray.length; n += 2) {
                this.ensureVisible(dArray[n], dArray[n + 1]);
                if (n == 0) {
                    this.append(EpsGraphics.format(dArray[n]) + " " + EpsGraphics.format(dArray[n + 1]) + " moveto", true);
                } else {
                    this.append(EpsGraphics.format(dArray[n] - d) + " " + EpsGraphics.format(dArray[n + 1] - d2) + " rlineto", true);
                }
                d = dArray[n];
                d2 = dArray[n + 1];
            }
            this.append(EpsGraphics.format(dArray[0]) + " " + EpsGraphics.format(dArray[1]) + " lineto", true);
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            for (n = 0; n < dArray.length; n += 2) {
                this.ensureVisible(dArray[n], dArray[n + 1]);
                if (n == 0) {
                    this.append(EpsGraphics.format(dArray[n]) + " " + EpsGraphics.format(dArray[n + 1]) + " moveto", true);
                } else {
                    this.append(EpsGraphics.format(dArray[n] - d) + " " + EpsGraphics.format(dArray[n + 1] - d2) + " rlineto", true);
                }
                d = dArray[n];
                d2 = dArray[n + 1];
            }
            this.append(EpsGraphics.format(dArray[0]) + " " + EpsGraphics.format(dArray[1]) + " lineto", true);
            this.append("closepath stroke", true);
        }
    }

    public void epsRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        this.checkCloseDone();
        this.ensureVisible(d, d2);
        this.ensureVisible(d + d3, d2 + d4);
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.epsRectangleInternal(d, d2, d3, d4, d5, d6, true);
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.epsRectangleInternal(d, d2, d3, d4, d5, d6, false);
            this.append("closepath stroke", true);
        }
    }

    public void epsRectangle(double d, double d2, double d3, double d4, double d5, double d6, HtmlColorGradient htmlColorGradient, ColorMapper colorMapper) {
        this.checkCloseDone();
        this.ensureVisible(d, d2);
        this.ensureVisible(d + d3, d2 + d4);
        this.setcolorgradientUsed = true;
        if (d5 == 0.0 && d6 == 0.0) {
            this.simplerectUsed = true;
            this.appendColorShort(colorMapper.getMappedColor(htmlColorGradient.getColor1()));
            this.appendColorShort(colorMapper.getMappedColor(htmlColorGradient.getColor2()));
            this.append(EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " " + EpsGraphics.format(d) + " " + EpsGraphics.format(d2), true);
            this.append("100 -1 1 {", true);
            this.append("100 div", true);
            this.append("newpath", true);
            this.append("2 index 2 index moveto", true);
            this.append("dup 5 index mul 2 mul dup 0 rlineto", true);
            this.append("neg 4 index 2 index mul 2 mul rlineto", true);
            this.append("closepath eoclip", true);
            this.append("10 index 10 index 10 index", true);
            this.append("10 index 10 index 10 index", true);
            this.append("6 index setcolorgradient", true);
            this.append("4 index 4 index 4 index 4 index simplerect", true);
            this.append("closepath eofill", true);
            this.append("pop", true);
            this.append("} for", true);
            this.append("pop pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("initclip", true);
        } else {
            this.roundrectUsed = true;
            this.appendColorShort(colorMapper.getMappedColor(htmlColorGradient.getColor1()));
            this.appendColorShort(colorMapper.getMappedColor(htmlColorGradient.getColor2()));
            this.append(EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " " + EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format((d5 + d6) / 2.0), true);
            this.append("100 -1 1 {", true);
            this.append("100 div", true);
            this.append("newpath", true);
            this.append("3 index 3 index moveto", true);
            this.append("dup 6 index mul 2 mul dup 0 rlineto", true);
            this.append("neg 5 index 2 index mul 2 mul rlineto", true);
            this.append("closepath eoclip", true);
            this.append("11 index 11 index 11 index", true);
            this.append("11 index 11 index 11 index", true);
            this.append("6 index setcolorgradient", true);
            this.append("5 index 5 index 5 index 5 index 5 index roundrect", true);
            this.append("closepath eofill", true);
            this.append("pop", true);
            this.append("} for", true);
            this.append("pop pop pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("initclip", true);
        }
    }

    private void epsRectangleInternal(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        if (d5 == 0.0 && d6 == 0.0) {
            this.simpleRectangle(d, d2, d3, d4, bl);
        } else {
            this.roundRectangle(d, d2, d3, d4, d5, d6);
        }
    }

    private void roundRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        this.append(EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " " + EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format((d5 + d6) / 2.0) + " roundrect", true);
        this.roundrectUsed = true;
    }

    private void simpleRectangle(double d, double d2, double d3, double d4, boolean bl) {
        if (this.dashSpace == 0.0 && this.dashVisible == 0.0 || bl) {
            this.append(EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " " + EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " simplerect", true);
            this.simplerectUsed = true;
        } else {
            this.epsVLine(d2, d, d + d3);
            this.epsVLine(d2 + d4, d, d + d3);
            this.epsHLine(d, d2, d2 + d4);
            this.epsHLine(d + d3, d2, d2 + d4);
        }
    }

    public void epsEllipse(double d, double d2, double d3, double d4, double d5, double d6) {
        this.checkCloseDone();
        this.ensureVisible(d + d3, d2 + d4);
        double d7 = 1.0;
        if (d3 != d4) {
            d7 = d4 / d3;
            this.append("gsave", true);
            this.append("1 " + EpsGraphics.format(d7) + " scale", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            double d8 = -d5 + 180.0 + 5.0;
            double d9 = -d5 - d6 + 180.0 - 5.0;
            this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2 / d7) + " " + EpsGraphics.format(d3) + " " + EpsGraphics.format(d8) + " " + EpsGraphics.format(d9) + " arc", true);
            this.append("stroke", true);
        }
        if (d7 != 1.0) {
            this.append("grestore", true);
        }
    }

    public void epsEllipse(double d, double d2, double d3, double d4) {
        this.checkCloseDone();
        this.ensureVisible(d + d3, d2 + d4);
        double d5 = 1.0;
        if (d3 != d4) {
            d5 = d4 / d3;
            this.append("gsave", true);
            this.append("1 " + EpsGraphics.format(d5) + " scale", true);
        }
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.append("newpath", true);
            this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2 / d5) + " " + EpsGraphics.format(d3) + " 0 360 arc", true);
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2 / d5) + " " + EpsGraphics.format(d3) + " 0 360 arc", true);
            this.append("closepath stroke", true);
        }
        if (d5 != 1.0) {
            this.append("grestore", true);
        }
    }

    protected void appendColor(Color color) {
        if (color == null) {
            return;
        }
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format(d3) + " setrgbcolor", true);
    }

    protected void appendColorShort(Color color) {
        if (color == null) {
            return;
        }
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format(d3), true);
    }

    public static String format(double d) {
        if (d == 0.0) {
            return "0";
        }
        String string = String.format(Locale.US, "%1.4f", d);
        if ((string = string.replaceAll("(\\.\\d*?)0+$", "$1")).endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected void append(String string, boolean bl) {
        if (bl && string.indexOf("  ") != -1) {
            throw new IllegalArgumentException(string);
        }
        this.body.append(string + "\n");
    }

    public final void linetoNoMacro(double d, double d2) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " lineto", true);
        this.ensureVisible(d, d2);
    }

    public final void movetoNoMacro(double d, double d2) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " moveto", true);
        this.ensureVisible(d, d2);
    }

    public final void curvetoNoMacro(double d, double d2, double d3, double d4, double d5, double d6) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " " + EpsGraphics.format(d5) + " " + EpsGraphics.format(d6) + " curveto", true);
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public void moveto(double d, double d2) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " moveto", true);
        this.ensureVisible(d, d2);
    }

    public void lineto(double d, double d2) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " lineto", true);
        this.ensureVisible(d, d2);
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " " + EpsGraphics.format(d5) + " " + EpsGraphics.format(d6) + " curveto", true);
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public void quadto(double d, double d2, double d3, double d4) {
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " " + EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " curveto", true);
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
    }

    public void newpath() {
        this.append("0 setlinewidth", true);
        this.appendColor(this.color);
        this.append("newpath", true);
    }

    public void closepath() {
        this.append("closepath", true);
    }

    public void fill(int n) {
        this.append("%fill", true);
        if (n == 0) {
            this.append("eofill", true);
        } else if (n == 1) {
            this.append("fill", true);
        }
    }

    public void drawImage(BufferedImage bufferedImage, double d, double d2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.append("gsave", true);
        this.append(EpsGraphics.format(d) + " " + EpsGraphics.format(d2) + " translate", true);
        this.append(EpsGraphics.format(n) + " " + EpsGraphics.format(n2) + " scale", true);
        this.append("" + n + " " + n2 + " 8 [" + n + " 0 0 -" + n2 + " 0 " + n2 + "]", true);
        this.append("{<", true);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2 - 1; i >= 0; --i) {
            for (int j = 0; j < n; ++j) {
                String string = EpsGraphics.getRgb(bufferedImage.getRGB(j, i));
                assert (string.length() == 6);
                stringBuilder.append(string);
            }
        }
        this.append(stringBuilder.toString(), true);
        this.append(">} false 3 colorimage", true);
        this.ensureVisible(d + (double)n, d2 + (double)n2);
        this.append("grestore", true);
    }

    static String getRgb(int n) {
        String string = "000000" + Integer.toHexString(n);
        return string.substring(string.length() - 6);
    }

    public void drawEps(String string, double d, double d2) {
        int n = string.indexOf("%%BoundingBox:");
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + "%%BoundingBox:".length()), " \n\t\r");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        assert (n4 >= n2);
        assert (n5 >= n3);
        this.append("gsave", true);
        double d3 = d - (double)n2;
        double d4 = d2 + (double)n5;
        this.append(EpsGraphics.format(d3) + " " + EpsGraphics.format(d4) + " translate", true);
        this.append("1 -1 scale", true);
        this.append(string, false);
        this.ensureVisible(d + (double)(n4 - n2), d2 + (double)(n5 - n3));
        this.append("grestore", true);
    }

    protected final double getDashVisible() {
        return this.dashVisible;
    }

    protected final double getDashSpace() {
        return this.dashSpace;
    }

    public void closeLink() {
        if (this.urlArea != null && this.urlArea.xmin != Integer.MAX_VALUE) {
            int n = this.urlArea.xmax - this.urlArea.xmin;
            int n2 = this.urlArea.ymax - this.urlArea.ymin;
            assert (n >= 0 && n2 >= 0);
            this.epsUrlLink(this.urlArea.xmin, this.urlArea.ymin, n, n2, this.urlArea.url);
        }
        this.urlArea = null;
    }

    public void epsUrlLink(int n, int n2, int n3, int n4, String string) {
        this.append("[ /Rect [ " + n + " " + n2 + " " + (n + n3) + " " + (n2 + n4) + " ]", true);
        this.append("/Border [ 0 0 0 ]", true);
        this.append("/Action << /Subtype /URI /URI (" + string + ") >>", true);
        this.append("/Subtype /Link", true);
        this.append("/ANN pdfmark", true);
    }

    public void openLink(String string) {
        this.urlArea = new UrlArea(string);
    }

    public void epsRectangleShadow(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.setStrokeColor(null);
        for (double d8 = 0.0; d8 <= d7; d8 += 0.5) {
            this.setFillColor(this.shadowManager.getColor(d8, d7));
            double d9 = d8;
            this.epsRectangle(d + d7 + d9, d2 + d7 + d9, d3 - 2.0 * d9, d4 - 2.0 * d9, d5 + 1.0, d6 + 1.0);
        }
    }

    public void epsPolygonShadow(double d, double ... dArray) {
        this.setStrokeColor(null);
        for (double d2 = 0.0; d2 <= d; d2 += 0.5) {
            this.setFillColor(this.shadowManager.getColor(d2, d));
            double d3 = d2;
            this.epsPolygon(this.shadowManager.getShadowDeltaPoints(d, d3, dArray));
        }
    }

    public void epsEllipseShadow(double d, double d2, double d3, double d4, double d5) {
        this.setStrokeColor(null);
        for (double d6 = 0.0; d6 <= d5; d6 += 0.5) {
            this.setFillColor(this.shadowManager.getColor(d6, d5));
            double d7 = d6;
            this.epsEllipse(d + d5, d2 + d5, d3 - d7, d4 - d7);
        }
    }

    static class UrlArea {
        private final String url;
        private int xmin = Integer.MAX_VALUE;
        private int xmax = Integer.MIN_VALUE;
        private int ymin = Integer.MAX_VALUE;
        private int ymax = Integer.MIN_VALUE;

        UrlArea(String string) {
            this.url = string;
        }

        void ensureVisible(int n, int n2) {
            if (n < this.xmin) {
                this.xmin = n;
            }
            if (n > this.xmax) {
                this.xmax = n;
            }
            if (n2 < this.ymin) {
                this.ymin = n2;
            }
            if (n2 > this.ymax) {
                this.ymax = n2;
            }
        }
    }
}

