/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.awt.geom.Point2D;
import java.util.Locale;
import net.sourceforge.plantuml.geom.AbstractLineSegment;
import net.sourceforge.plantuml.geom.Box;
import net.sourceforge.plantuml.geom.InflateData;
import net.sourceforge.plantuml.geom.Point2DInt;

public class LineSegmentInt
extends AbstractLineSegment {
    private final Point2DInt p1;
    private final Point2DInt p2;

    public String toString() {
        return String.format(Locale.US, "( %d,%d - %d,%d )", this.p1.getXint(), this.p1.getYint(), this.p2.getXint(), this.p2.getYint());
    }

    public LineSegmentInt(int n, int n2, int n3, int n4) {
        this(new Point2DInt(n, n2), new Point2DInt(n3, n4));
    }

    public LineSegmentInt(Point2DInt point2DInt, Point2DInt point2DInt2) {
        this.p1 = point2DInt;
        this.p2 = point2DInt2;
        if (point2DInt.equals(point2DInt2)) {
            throw new IllegalArgumentException();
        }
        assert (point2DInt != null && point2DInt2 != null);
        assert (this.getLength() > 0.0);
        assert (this.getDistance(this) == 0.0);
    }

    public boolean containsPoint(Point2D point2D) {
        return this.side(point2D) == 0.0 && LineSegmentInt.isBetween(point2D, this.p1, this.p2);
    }

    public double side(Box box2) {
        Point2DInt[] point2DIntArray = box2.getCorners();
        double d = this.side(point2DIntArray[0]);
        double d2 = this.side(point2DIntArray[1]);
        double d3 = this.side(point2DIntArray[2]);
        double d4 = this.side(point2DIntArray[3]);
        if (d > 0.0 && d2 > 0.0 && d3 > 0.0 && d4 > 0.0) {
            return 1.0;
        }
        if (d < 0.0 && d2 < 0.0 && d3 < 0.0 && d4 < 0.0) {
            return -1.0;
        }
        return 0.0;
    }

    public boolean doesIntersectButNotSameExtremity(LineSegmentInt lineSegmentInt) {
        if (!this.doesIntersect(lineSegmentInt)) {
            return false;
        }
        return !this.atLeastOneCommonExtremities(lineSegmentInt);
    }

    public boolean sameExtremities(LineSegmentInt lineSegmentInt) {
        if (this.p1.equals(lineSegmentInt.p1) && this.p2.equals(lineSegmentInt.p2)) {
            return true;
        }
        return this.p1.equals(lineSegmentInt.p2) && this.p2.equals(lineSegmentInt.p1);
    }

    public boolean atLeastOneCommonExtremities(LineSegmentInt lineSegmentInt) {
        if (this.p1.equals(lineSegmentInt.p1)) {
            return true;
        }
        if (this.p1.equals(lineSegmentInt.p2)) {
            return true;
        }
        if (this.p2.equals(lineSegmentInt.p1)) {
            return true;
        }
        return this.p2.equals(lineSegmentInt.p2);
    }

    public Point2DInt getCommonExtremities(LineSegmentInt lineSegmentInt) {
        if (this.p1.equals(lineSegmentInt.p1)) {
            return this.p1;
        }
        if (this.p1.equals(lineSegmentInt.p2)) {
            return this.p1;
        }
        if (this.p2.equals(lineSegmentInt.p1)) {
            return this.p2;
        }
        if (this.p2.equals(lineSegmentInt.p2)) {
            return this.p2;
        }
        return null;
    }

    public Point2DInt getOtherExtremity(Point2DInt point2DInt) {
        if (point2DInt == null) {
            throw new IllegalArgumentException();
        }
        if (point2DInt.equals(this.p1)) {
            return this.p2;
        }
        if (point2DInt.equals(this.p2)) {
            return this.p1;
        }
        throw new IllegalArgumentException();
    }

    public Point2DInt getP1() {
        return this.p1;
    }

    public Point2DInt getP2() {
        return this.p2;
    }

    public double getX1() {
        return this.p1.getXint();
    }

    public double getX2() {
        return this.p2.getXint();
    }

    public double getY1() {
        return this.p1.getYint();
    }

    public double getY2() {
        return this.p2.getYint();
    }

    public Point2DInt getTranslatedPoint(Point2DInt point2DInt) {
        int n = this.p2.getXint() - this.p1.getXint();
        int n2 = this.p2.getYint() - this.p1.getYint();
        return new Point2DInt(point2DInt.getXint() + n, point2DInt.getYint() + n2);
    }

    public Point2DInt getCenter() {
        return new Point2DInt((this.p1.getXint() + this.p2.getXint()) / 2, (this.p1.getYint() + this.p2.getYint()) / 2);
    }

    public int getMinX() {
        return Math.min(this.p1.getXint(), this.p2.getXint());
    }

    public int getMaxX() {
        return Math.max(this.p1.getXint(), this.p2.getXint());
    }

    public int getMinY() {
        return Math.min(this.p1.getYint(), this.p2.getYint());
    }

    public int getMaxY() {
        return Math.max(this.p1.getYint(), this.p2.getYint());
    }

    public Point2DInt ortho(Point2D.Double double_, double d) {
        double d2 = this.p2.getY() - this.p1.getY();
        double d3 = -(this.p2.getX() - this.p1.getX());
        double d4 = 1.0 * d / 100.0;
        double d5 = double_.x + d2 * d4;
        double d6 = double_.y + d3 * d4;
        return new Point2DInt((int)Math.round(d5), (int)Math.round(d6));
    }

    public LineSegmentInt translate(int n, int n2) {
        return new LineSegmentInt(this.p1.translate(n, n2), this.p2.translate(n, n2));
    }

    public LineSegmentInt inflateXAlpha(InflateData inflateData) {
        int n = inflateData.getPos();
        int n2 = inflateData.getInflation();
        if (this.isHorizontal()) {
            return new LineSegmentInt(this.p1.inflateX(inflateData), this.p2.inflateX(inflateData));
        }
        if (this.getP1().getXint() == n && this.getP2().getXint() == n) {
            return this.translate(n2 / 2, 0);
        }
        if (this.getP1().getXint() <= n && this.getP2().getXint() <= n) {
            return this;
        }
        if (this.getP1().getXint() >= n && this.getP2().getXint() >= n) {
            return this.translate(n2, 0);
        }
        throw new UnsupportedOperationException(this.toString() + " " + inflateData);
    }

    public LineSegmentInt inflateYAlpha(InflateData inflateData) {
        int n = inflateData.getPos();
        int n2 = inflateData.getInflation();
        if (this.isVertical()) {
            return new LineSegmentInt(this.p1.inflateY(inflateData), this.p2.inflateY(inflateData));
        }
        if (this.getP1().getYint() == n && this.getP2().getYint() == n) {
            return this.translate(0, n2 / 2);
        }
        if (this.getP1().getYint() <= n && this.getP2().getYint() <= n) {
            return this;
        }
        if (this.getP1().getYint() >= n && this.getP2().getYint() >= n) {
            return this.translate(0, n2);
        }
        throw new UnsupportedOperationException();
    }

    public Point2DInt getSegIntersection(AbstractLineSegment abstractLineSegment) {
        Point2D point2D = super.getSegIntersection(abstractLineSegment);
        if (point2D == null) {
            return null;
        }
        return new Point2DInt((int)Math.round(point2D.getX()), (int)Math.round(point2D.getY()));
    }
}

