/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.geom.AbstractPolyline;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;
import net.sourceforge.plantuml.geom.XMoveable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolylineBreakeable
extends AbstractPolyline
implements Polyline {
    private final List<Breakure> breakures = new ArrayList<Breakure>();

    public PolylineBreakeable copy(Pointable pointable, Pointable pointable2) {
        PolylineBreakeable polylineBreakeable = new PolylineBreakeable(pointable, pointable2);
        polylineBreakeable.breakures.addAll(this.breakures);
        return polylineBreakeable;
    }

    public PolylineBreakeable(Pointable pointable, Pointable pointable2) {
        super(pointable, pointable2);
    }

    @Override
    public List<LineSegmentInt> segments() {
        if (this.breakures.size() == 0) {
            return Collections.singletonList(new LineSegmentInt(this.getStart().getPosition(), this.getEnd().getPosition()));
        }
        ArrayList<LineSegmentInt> arrayList = new ArrayList<LineSegmentInt>();
        Point2DInt point2DInt = this.getStart().getPosition();
        for (Breakure breakure : this.breakures) {
            Point2DInt point2DInt2 = this.getBreakurePoint(breakure);
            arrayList.add(new LineSegmentInt(point2DInt, point2DInt2));
            point2DInt = point2DInt2;
        }
        arrayList.add(new LineSegmentInt(point2DInt, this.getEnd().getPosition()));
        assert (this.nbSegments() == arrayList.size());
        return Collections.unmodifiableList(arrayList);
    }

    private Point2DInt getBreakurePoint(Breakure breakure) {
        LineSegmentInt lineSegmentInt = new LineSegmentInt(this.getStart().getPosition(), this.getEnd().getPosition());
        return lineSegmentInt.ortho(lineSegmentInt.startTranslatedAsVector(breakure.u), breakure.d);
    }

    @Override
    public int nbSegments() {
        return this.breakures.size() + 1;
    }

    public List<XMoveable> getFreedoms() {
        ArrayList<XMoveable> arrayList = new ArrayList<XMoveable>();
        for (final Breakure breakure : this.breakures) {
            arrayList.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(d)";
                }

                public void moveX(int n) {
                    breakure.d = breakure.d + n;
                }
            });
            arrayList.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(u)";
                }

                public void moveX(int n) {
                    breakure.u = breakure.u + n;
                }
            });
            arrayList.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(ud)";
                }

                public void moveX(int n) {
                    breakure.u = breakure.u + n;
                    breakure.d = breakure.d + n;
                }
            });
            arrayList.add(new XMoveable(){

                public String toString() {
                    return super.toString() + " " + PolylineBreakeable.this.toString() + "(dud)";
                }

                public void moveX(int n) {
                    breakure.u = breakure.u + n;
                    breakure.d = breakure.d - n;
                }
            });
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void insertBetweenPoint(int n, int n2) {
        this.breakures.add(new Breakure(n, n2));
    }

    private void breakMore() {
        if (this.breakures.size() == 1) {
            Breakure breakure = this.breakures.get(0);
            this.insertBetweenPoint(breakure.u / 2, 0);
        }
    }

    static class Breakure {
        private int d;
        private int u;

        public Breakure(int n, int n2) {
            this.u = n;
            this.d = n2;
        }
    }
}

