/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.geom.kinetic.MoveObserver;
import net.sourceforge.plantuml.geom.kinetic.Path;
import net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import net.sourceforge.plantuml.geom.kinetic.Quadrant;
import net.sourceforge.plantuml.geom.kinetic.QuadrantMapper;
import net.sourceforge.plantuml.geom.kinetic.VectorForce;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class World
implements MoveObserver {
    private final List<Path> paths = new ArrayList<Path>();
    private final Map<Point2DCharge, Path> pathOfPoints = new HashMap<Point2DCharge, Path>();
    private final List<Frame> frames = new ArrayList<Frame>();
    private QuadrantMapper quadrantMapper;

    public void addFrame(Frame frame) {
        this.frames.add(frame);
    }

    public void addPath(Path path2) {
        this.paths.add(path2);
    }

    public VectorForce getElectricForce(Point2DCharge point2DCharge) {
        VectorForce vectorForce = new VectorForce(0.0, 0.0);
        Quadrant quadrant = new Quadrant(point2DCharge);
        for (Quadrant quadrant2 : quadrant.neighbourhood()) {
            for (Point2DCharge point2DCharge2 : this.quadrantMapper.getAllPoints(quadrant2)) {
                Path path2 = this.pathOfPoints.get(point2DCharge2);
                if (path2.containsPoint2DCharge(point2DCharge)) continue;
                vectorForce = vectorForce.plus(World.getElectricForce(point2DCharge, point2DCharge2));
            }
        }
        return vectorForce;
    }

    private VectorForce getElectricForceSlow(Point2DCharge point2DCharge) {
        VectorForce vectorForce = new VectorForce(0.0, 0.0);
        for (Path path2 : this.paths) {
            if (path2.containsPoint2DCharge(point2DCharge)) continue;
            for (Point2DCharge point2DCharge2 : path2.getPoints()) {
                vectorForce = vectorForce.plus(World.getElectricForce(point2DCharge, point2DCharge2));
            }
        }
        return vectorForce;
    }

    private static VectorForce getElectricForce(Point2DCharge point2DCharge, Point2DCharge point2DCharge2) {
        double d = point2DCharge.distance(point2DCharge2);
        if (d == 0.0) {
            return new VectorForce(0.0, 0.0);
        }
        VectorForce vectorForce = new VectorForce(point2DCharge2.getX() - point2DCharge.getX(), point2DCharge2.getY() - point2DCharge.getY());
        double d2 = 100.0 * point2DCharge.getCharge() * point2DCharge2.getCharge() / d / d;
        return vectorForce.normaliseTo(d2);
    }

    private static VectorForce getAtomicForce(Point2DCharge point2DCharge, Point2DCharge point2DCharge2) {
        double d = point2DCharge.distance(point2DCharge2);
        if (d == 0.0) {
            return new VectorForce(0.0, 0.0);
        }
        VectorForce vectorForce = new VectorForce(point2DCharge2.getX() - point2DCharge.getX(), point2DCharge2.getY() - point2DCharge.getY());
        double d2 = 1000.0 / d / d / d;
        if (d2 > 5.0) {
            d2 = 5.0;
        }
        return vectorForce.normaliseTo(d2);
    }

    Map<Point2DCharge, VectorForce> getForces() {
        LinkedHashMap<Point2DCharge, VectorForce> linkedHashMap = new LinkedHashMap<Point2DCharge, VectorForce>();
        for (Path path2 : this.paths) {
            for (Point2DCharge point2DCharge : path2.getPoints()) {
                VectorForce vectorForce = path2.getElasticForce(point2DCharge);
                VectorForce vectorForce2 = this.getElectricForce(point2DCharge);
                VectorForce vectorForce3 = vectorForce.plus(vectorForce2);
                for (Frame frame : this.frames) {
                    Point2D point2D = frame.getFrontierPointViewBy(point2DCharge);
                    if (point2D == null) continue;
                    Point2DCharge point2DCharge2 = new Point2DCharge(point2D, 1.0);
                    vectorForce3 = vectorForce3.plus(World.getAtomicForce(point2DCharge, point2DCharge2));
                }
                linkedHashMap.put(point2DCharge, vectorForce3);
            }
        }
        return linkedHashMap;
    }

    public double onePass() {
        double d = 0.0;
        Map<Point2DCharge, VectorForce> map = this.getForces();
        for (Map.Entry<Point2DCharge, VectorForce> entry : map.entrySet()) {
            VectorForce vectorForce = entry.getValue();
            d += vectorForce.getLength();
            entry.getKey().apply(vectorForce);
        }
        return d;
    }

    public final Collection<Path> getPaths() {
        return Collections.unmodifiableCollection(this.paths);
    }

    public void renderContinue() {
        this.quadrantMapper = new QuadrantMapper();
        this.pathOfPoints.clear();
        for (Path path2 : this.paths) {
            path2.renderContinue();
        }
        for (Path path2 : this.paths) {
            for (Point2DCharge point2DCharge : path2.getPoints()) {
                point2DCharge.setMoveObserver(this);
                this.quadrantMapper.addPoint(point2DCharge);
                this.pathOfPoints.put(point2DCharge, path2);
            }
        }
    }

    @Override
    public void pointMoved(Point2DCharge point2DCharge) {
        this.quadrantMapper.updatePoint(point2DCharge);
    }
}

