/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicStrings
extends AbstractTextBlock
implements IEntityImage {
    private final double margin = 5.0;
    private final HtmlColor background;
    private final UFont font;
    private final HtmlColor maincolor;
    private final HtmlColor hyperlinkColor = HtmlColorUtils.BLUE;
    private final boolean useUnderlineForHyperlink = true;
    private final List<String> strings;
    private final BufferedImage image;
    private final GraphicPosition position;

    public static IEntityImage createForError(List<String> list, boolean bl) {
        if (bl) {
            return new GraphicStrings(list, UFont.sansSerif(14).bold(), HtmlColorUtils.BLACK, HtmlColorUtils.RED_LIGHT, null, null);
        }
        return new GraphicStrings(list, UFont.sansSerif(14).bold(), HtmlColorSet.getInstance().getColorIfValid("#33FF02"), HtmlColorUtils.BLACK, null, null);
    }

    public static TextBlockBackcolored createGreenOnBlackMonospaced(List<String> list) {
        return new GraphicStrings(list, GraphicStrings.monospaced14(), HtmlColorUtils.GREEN, HtmlColorUtils.BLACK, null, null);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> list) {
        return new GraphicStrings(list, GraphicStrings.sansSerif12(), HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, null, null);
    }

    public static TextBlockBackcolored createBlackOnWhiteMonospaced(List<String> list) {
        return new GraphicStrings(list, GraphicStrings.monospaced14(), HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, null, null);
    }

    public static TextBlockBackcolored createBlackOnWhite(List<String> list, BufferedImage bufferedImage, GraphicPosition graphicPosition) {
        return new GraphicStrings(list, GraphicStrings.sansSerif12(), HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, bufferedImage, graphicPosition);
    }

    private static UFont sansSerif12() {
        return UFont.sansSerif(12);
    }

    private static UFont monospaced14() {
        return UFont.monospaced(14);
    }

    private GraphicStrings(List<String> list, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, BufferedImage bufferedImage, GraphicPosition graphicPosition) {
        this.strings = list;
        this.font = uFont;
        this.maincolor = htmlColor;
        this.background = htmlColor2;
        this.image = bufferedImage;
        this.position = graphicPosition;
    }

    private TextBlock getTextBlock() {
        TextBlock textBlock = null;
        textBlock = Display.create(this.strings).create(new FontConfiguration(this.font, this.maincolor, this.hyperlinkColor, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        return textBlock;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UTranslate(5.0, 5.0));
        Dimension2D dimension2D = this.calculateDimensionInternal(uGraphic.getStringBounder());
        this.getTextBlock().drawU(uGraphic.apply(new UChangeColor(this.maincolor)));
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                uGraphic.apply(new UTranslate((dimension2D.getWidth() - (double)this.image.getWidth()) / 2.0, dimension2D.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                uGraphic.apply(new UTranslate(dimension2D.getWidth() - (double)this.image.getWidth(), dimension2D.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                uGraphic.apply(new UTranslate(dimension2D.getWidth() - (double)this.image.getWidth() - 1.0, 1.0)).draw(new UImage(this.image));
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return Dimension2DDouble.delta(this.calculateDimensionInternal(stringBounder), 10.0);
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTextBlock().calculateDimension(stringBounder);
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                dimension2D = new Dimension2DDouble(dimension2D.getWidth(), dimension2D.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                dimension2D = new Dimension2DDouble(dimension2D.getWidth() + (double)this.image.getWidth(), dimension2D.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                dimension2D = new Dimension2DDouble(dimension2D.getWidth() + (double)this.image.getWidth(), dimension2D.getHeight());
            }
        }
        return dimension2D;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.background;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return false;
    }
}

