/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgAttributes {
    private final Map<String, String> attributes = new TreeMap<String, String>();

    public SvgAttributes() {
    }

    private SvgAttributes(SvgAttributes svgAttributes) {
        this.attributes.putAll(svgAttributes.attributes);
    }

    public SvgAttributes(String string) {
        Pattern2 pattern2 = MyPattern.cmpile("(\\w+)\\s*=\\s*([%g][^%g]*[%g]|(?:\\w+))");
        Matcher2 matcher2 = pattern2.matcher(string);
        while (matcher2.find()) {
            this.attributes.put(matcher2.group(1), StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher2.group(2)));
        }
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SvgAttributes add(String string, String string2) {
        SvgAttributes svgAttributes = new SvgAttributes(this);
        svgAttributes.attributes.put(string, string2);
        return svgAttributes;
    }

    public SvgAttributes add(SvgAttributes svgAttributes) {
        SvgAttributes svgAttributes2 = new SvgAttributes(this);
        svgAttributes2.attributes.putAll(svgAttributes.attributes);
        return svgAttributes2;
    }
}

