/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UHorizontalLine;

public class TextBlockLineBefore
extends AbstractTextBlock
implements TextBlock,
WithPorts {
    private final TextBlock textBlock;
    private final char separator;
    private final TextBlock title;

    public TextBlockLineBefore(TextBlock textBlock, char c, TextBlock textBlock2) {
        this.textBlock = textBlock;
        this.separator = c;
        this.title = textBlock2;
    }

    public TextBlockLineBefore(TextBlock textBlock, char c) {
        this(textBlock, c, null);
    }

    public TextBlockLineBefore(TextBlock textBlock) {
        this(textBlock, '\u0000');
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        if (this.title != null) {
            Dimension2D dimension2D2 = this.title.calculateDimension(stringBounder);
            return Dimension2DDouble.atLeast(dimension2D, dimension2D2.getWidth() + 8.0, dimension2D2.getHeight());
        }
        return dimension2D;
    }

    public void drawU(UGraphic uGraphic) {
        HtmlColor htmlColor = uGraphic.getParam().getColor();
        if (this.title == null) {
            UHorizontalLine.infinite(1.0, 1.0, this.separator).drawMe(uGraphic);
        }
        this.textBlock.drawU(uGraphic);
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        if (this.title != null) {
            UHorizontalLine.infinite(1.0, 1.0, this.title, this.separator).drawMe(uGraphic);
        }
    }

    public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
        return this.textBlock.getInnerPosition(string, stringBounder, innerStrategy);
    }

    public Ports getPorts(StringBounder stringBounder) {
        return ((WithPorts)((Object)this.textBlock)).getPorts(stringBounder);
    }
}

