/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockBordered;
import net.sourceforge.plantuml.graphic.TextBlockHorizontal;
import net.sourceforge.plantuml.graphic.TextBlockMarged;
import net.sourceforge.plantuml.graphic.TextBlockMinWidth;
import net.sourceforge.plantuml.graphic.TextBlockTitle;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.posimo.PositionableImpl;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class TextBlockUtils {
    private static final Graphics2D gg;

    public static TextBlock bordered(TextBlock textBlock, UStroke uStroke, HtmlColor htmlColor, HtmlColor htmlColor2, double d) {
        return new TextBlockBordered(textBlock, uStroke, htmlColor, htmlColor2, d);
    }

    public static TextBlock title(FontConfiguration fontConfiguration, Display display, ISkinParam iSkinParam) {
        UStroke uStroke = iSkinParam.getThickness(LineParam.titleBorder, null);
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getHtmlColor(iSkinParam, ColorParam.titleBorder);
        HtmlColor htmlColor2 = rose.getHtmlColor(iSkinParam, ColorParam.titleBackground);
        TextBlockTitle textBlockTitle = new TextBlockTitle(fontConfiguration, display, iSkinParam);
        if (uStroke == null && htmlColor == null) {
            return textBlockTitle;
        }
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        if (htmlColor == null) {
            htmlColor = HtmlColorUtils.BLACK;
        }
        double d = iSkinParam.getRoundCorner("titleBorder", null);
        return TextBlockUtils.withMargin(TextBlockUtils.bordered(textBlockTitle, uStroke, htmlColor, htmlColor2, d), 2.0, 2.0);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2) {
        return new TextBlockMarged(textBlock, d, d, d2, d2);
    }

    public static TextBlock withMargin(TextBlock textBlock, double d, double d2, double d3, double d4) {
        return new TextBlockMarged(textBlock, d, d2, d3, d4);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double d, HorizontalAlignment horizontalAlignment) {
        return new TextBlockMinWidth(textBlock, d, horizontalAlignment);
    }

    public static TextBlock empty(final double d, final double d2) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, Point2D point2D) {
        return new PositionableImpl(point2D, textBlock.calculateDimension(stringBounder));
    }

    public static TextBlock mergeLR(TextBlock textBlock, TextBlock textBlock2, VerticalAlignment verticalAlignment) {
        return new TextBlockHorizontal(textBlock, textBlock2, verticalAlignment);
    }

    public static TextBlock mergeTB(TextBlock textBlock, TextBlock textBlock2, HorizontalAlignment horizontalAlignment) {
        return new TextBlockVertical2(textBlock, textBlock2, horizontalAlignment);
    }

    public static MinMax getMinMax(TextBlock textBlock, StringBounder stringBounder) {
        LimitFinder limitFinder = new LimitFinder(stringBounder, false);
        textBlock.drawU(limitFinder);
        return limitFinder.getMinMax();
    }

    public static boolean isEmpty(TextBlock textBlock, StringBounder stringBounder) {
        if (textBlock == null) {
            return true;
        }
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        return dimension2D.getHeight() == 0.0 && dimension2D.getWidth() == 0.0;
    }

    public static FontRenderContext getFontRenderContext() {
        return gg.getFontRenderContext();
    }

    public static LineMetrics getLineMetrics(UFont uFont, String string) {
        return uFont.getLineMetrics(gg, string);
    }

    public static FontMetrics getFontMetrics(Font font) {
        return gg.getFontMetrics(font);
    }

    public static TextBlock fullInnerPosition(final TextBlock textBlock, final String string) {
        return new TextBlock(){

            public void drawU(UGraphic uGraphic) {
                textBlock.drawU(uGraphic);
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return textBlock.calculateDimension(stringBounder);
            }

            public Rectangle2D getInnerPosition(String string2, StringBounder stringBounder, InnerStrategy innerStrategy) {
                if (innerStrategy.check(string, string2)) {
                    Dimension2D dimension2D = this.calculateDimension(stringBounder);
                    return new Rectangle2D.Double(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
                }
                return null;
            }
        };
    }

    static {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 1);
        gg = bufferedImage.createGraphics();
    }
}

